/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.soundcloud.extractors;

import java.util.List;
import java.util.Objects;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.comments.CommentsInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.DateWrapper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.soundcloud.SoundcloudParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.Description;

public class SoundcloudCommentsInfoItemExtractor
implements CommentsInfoItemExtractor {
    private final JsonObject json;
    private final String url;

    public SoundcloudCommentsInfoItemExtractor(JsonObject json, String url) {
        this.json = json;
        this.url = url;
    }

    @Override
    public String getCommentId() {
        return Objects.toString(this.json.getLong("id"), null);
    }

    @Override
    @Nonnull
    public Description getCommentText() {
        return new Description(this.json.getString("body"), 3);
    }

    @Override
    public String getUploaderName() {
        return this.json.getObject("user").getString("username");
    }

    @Override
    @Nonnull
    public List<Image> getUploaderAvatars() {
        return SoundcloudParsingHelper.getAllImagesFromArtworkOrAvatarUrl(this.json.getObject("user").getString("avatar_url"));
    }

    @Override
    public boolean isUploaderVerified() throws ParsingException {
        return this.json.getObject("user").getBoolean("verified");
    }

    @Override
    public int getStreamPosition() {
        return this.json.getInt("timestamp") / 1000;
    }

    @Override
    public String getUploaderUrl() {
        return this.json.getObject("user").getString("permalink_url");
    }

    @Override
    public String getTextualUploadDate() {
        return this.json.getString("created_at");
    }

    @Override
    @Nullable
    public DateWrapper getUploadDate() throws ParsingException {
        return new DateWrapper(SoundcloudParsingHelper.parseDateFrom(this.getTextualUploadDate()));
    }

    @Override
    public String getName() throws ParsingException {
        return this.json.getObject("user").getString("permalink");
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    @Nonnull
    public List<Image> getThumbnails() {
        return SoundcloudParsingHelper.getAllImagesFromArtworkOrAvatarUrl(this.json.getObject("user").getString("avatar_url"));
    }
}

