/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.peertube.linkHandler;

import java.net.MalformedURLException;
import java.net.URL;
import org.watermedia.shaded.schabi.newpipe.extractor.ServiceList;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.FoundAdException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.LinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Parser;

public final class PeertubeStreamLinkHandlerFactory
extends LinkHandlerFactory {
    private static final PeertubeStreamLinkHandlerFactory INSTANCE = new PeertubeStreamLinkHandlerFactory();
    private static final String ID_PATTERN = "(/w/|(/videos/(watch/|embed/)?))(?!p/)([^/?&#]*)";
    public static final String VIDEO_API_ENDPOINT = "/api/v1/videos/";
    private static final String VIDEO_PATH = "/videos/watch/";

    private PeertubeStreamLinkHandlerFactory() {
    }

    public static PeertubeStreamLinkHandlerFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public String getUrl(String id2) throws ParsingException, UnsupportedOperationException {
        return this.getUrl(id2, ServiceList.PeerTube.getBaseUrl());
    }

    @Override
    public String getUrl(String id2, String baseUrl) {
        return baseUrl + VIDEO_PATH + id2;
    }

    @Override
    public String getId(String url) throws ParsingException, UnsupportedOperationException {
        return Parser.matchGroup(ID_PATTERN, url, 4);
    }

    @Override
    public boolean onAcceptUrl(String url) throws FoundAdException {
        if (url.contains("/playlist/")) {
            return false;
        }
        try {
            new URL(url);
            this.getId(url);
            return true;
        }
        catch (MalformedURLException | ParsingException e) {
            return false;
        }
    }
}

