/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.peertube.linkHandler;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.watermedia.shaded.schabi.newpipe.extractor.ServiceList;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Parser;

public final class PeertubePlaylistLinkHandlerFactory
extends ListLinkHandlerFactory {
    private static final PeertubePlaylistLinkHandlerFactory INSTANCE = new PeertubePlaylistLinkHandlerFactory();
    private static final String ID_PATTERN = "(/videos/watch/playlist/|/w/p/)([^/?&#]*)";
    private static final String API_ID_PATTERN = "/video-playlists/([^/?&#]*)";

    private PeertubePlaylistLinkHandlerFactory() {
    }

    public static PeertubePlaylistLinkHandlerFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public String getUrl(String id2, List<String> contentFilters, String sortFilter) throws ParsingException, UnsupportedOperationException {
        return this.getUrl(id2, contentFilters, sortFilter, ServiceList.PeerTube.getBaseUrl());
    }

    @Override
    public String getUrl(String id2, List<String> contentFilters, String sortFilter, String baseUrl) throws ParsingException, UnsupportedOperationException {
        return baseUrl + "/api/v1/video-playlists/" + id2;
    }

    @Override
    public String getId(String url) throws ParsingException, UnsupportedOperationException {
        try {
            return Parser.matchGroup(ID_PATTERN, url, 2);
        }
        catch (ParsingException parsingException) {
            return Parser.matchGroup1(API_ID_PATTERN, url);
        }
    }

    @Override
    public boolean onAcceptUrl(String url) {
        try {
            new URL(url);
            this.getId(url);
            return true;
        }
        catch (MalformedURLException | ParsingException e) {
            return false;
        }
    }
}

