/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.peertube.extractors;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.watermedia.shaded.com.grack.nanojson.JsonArray;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.com.grack.nanojson.JsonWriter;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.jsoup.Jsoup;
import org.watermedia.shaded.jsoup.nodes.Document;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.Page;
import org.watermedia.shaded.schabi.newpipe.extractor.ServiceList;
import org.watermedia.shaded.schabi.newpipe.extractor.comments.CommentsInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.DateWrapper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.peertube.PeertubeParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.Description;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.JsonUtils;

public class PeertubeCommentsInfoItemExtractor
implements CommentsInfoItemExtractor {
    @Nonnull
    private final JsonObject item;
    @Nullable
    private final JsonArray children;
    @Nonnull
    private final String url;
    @Nonnull
    private final String baseUrl;
    private final boolean isReply;
    private Integer replyCount;

    public PeertubeCommentsInfoItemExtractor(@Nonnull JsonObject item, @Nullable JsonArray children, @Nonnull String url, @Nonnull String baseUrl, boolean isReply) {
        this.item = item;
        this.children = children;
        this.url = url;
        this.baseUrl = baseUrl;
        this.isReply = isReply;
    }

    @Override
    public String getUrl() throws ParsingException {
        return this.url + "/" + this.getCommentId();
    }

    @Override
    @Nonnull
    public List<Image> getThumbnails() {
        return this.getUploaderAvatars();
    }

    @Override
    public String getName() throws ParsingException {
        return JsonUtils.getString(this.item, "account.displayName");
    }

    @Override
    public String getTextualUploadDate() throws ParsingException {
        return JsonUtils.getString(this.item, "createdAt");
    }

    @Override
    public DateWrapper getUploadDate() throws ParsingException {
        String textualUploadDate = this.getTextualUploadDate();
        return new DateWrapper(PeertubeParsingHelper.parseDateFrom(textualUploadDate));
    }

    @Override
    @Nonnull
    public Description getCommentText() throws ParsingException {
        String htmlText = JsonUtils.getString(this.item, "text");
        try {
            Document doc = Jsoup.parse(htmlText);
            String text = doc.body().text();
            return new Description(text, 3);
        }
        catch (Exception e) {
            String text = htmlText.replaceAll("(?s)<[^>]*>(\\s*<[^>]*>)*", "");
            return new Description(text, 3);
        }
    }

    @Override
    public String getCommentId() {
        return Objects.toString(this.item.getLong("id"), null);
    }

    @Override
    @Nonnull
    public List<Image> getUploaderAvatars() {
        return PeertubeParsingHelper.getAvatarsFromOwnerAccountOrVideoChannelObject(this.baseUrl, this.item.getObject("account"));
    }

    @Override
    public String getUploaderName() throws ParsingException {
        return JsonUtils.getString(this.item, "account.name") + "@" + JsonUtils.getString(this.item, "account.host");
    }

    @Override
    public String getUploaderUrl() throws ParsingException {
        String name = JsonUtils.getString(this.item, "account.name");
        String host = JsonUtils.getString(this.item, "account.host");
        return ServiceList.PeerTube.getChannelLHFactory().fromId("accounts/" + name + "@" + host, this.baseUrl).getUrl();
    }

    @Override
    @Nullable
    public Page getReplies() throws ParsingException {
        if (this.getReplyCount() == 0) {
            return null;
        }
        String threadId = JsonUtils.getNumber(this.item, "threadId").toString();
        String repliesUrl = this.url + "/" + threadId;
        if (this.isReply && this.children != null && !this.children.isEmpty()) {
            JsonObject pageContent = new JsonObject();
            pageContent.put("children", this.children);
            return new Page(repliesUrl, threadId, JsonWriter.string(pageContent).getBytes(StandardCharsets.UTF_8));
        }
        return new Page(repliesUrl, threadId);
    }

    @Override
    public int getReplyCount() throws ParsingException {
        if (this.replyCount == null) {
            this.replyCount = this.children != null && !this.children.isEmpty() ? Integer.valueOf(this.children.size()) : Integer.valueOf(JsonUtils.getNumber(this.item, "totalReplies").intValue());
        }
        return this.replyCount;
    }

    @Override
    public boolean hasCreatorReply() {
        return this.item.has("totalRepliesFromVideoAuthor") && this.item.getInt("totalRepliesFromVideoAuthor") > 0;
    }
}

