/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.peertube.extractors;

import java.util.List;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.channel.ChannelInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.services.peertube.PeertubeParsingHelper;

public class PeertubeChannelInfoItemExtractor
implements ChannelInfoItemExtractor {
    private final JsonObject item;
    private final String baseUrl;

    public PeertubeChannelInfoItemExtractor(@Nonnull JsonObject item, @Nonnull String baseUrl) {
        this.item = item;
        this.baseUrl = baseUrl;
    }

    @Override
    public String getName() throws ParsingException {
        return this.item.getString("displayName");
    }

    @Override
    public String getUrl() throws ParsingException {
        return this.item.getString("url");
    }

    @Override
    @Nonnull
    public List<Image> getThumbnails() throws ParsingException {
        return PeertubeParsingHelper.getAvatarsFromOwnerAccountOrVideoChannelObject(this.baseUrl, this.item);
    }

    @Override
    public String getDescription() throws ParsingException {
        return this.item.getString("description");
    }

    @Override
    public long getSubscriberCount() throws ParsingException {
        return this.item.getInt("followersCount");
    }

    @Override
    public long getStreamCount() throws ParsingException {
        return -1L;
    }

    @Override
    public boolean isVerified() throws ParsingException {
        return false;
    }
}

