/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.peertube;

import java.util.Arrays;
import java.util.List;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.channel.ChannelExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.channel.tabs.ChannelTabExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.comments.CommentsExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.kiosk.KioskList;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.LinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.LinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.SearchQueryHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.SearchQueryHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.playlist.PlaylistExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.search.SearchExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.peertube.PeertubeInstance;
import org.watermedia.shaded.schabi.newpipe.extractor.services.peertube.extractors.PeertubeAccountExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.peertube.extractors.PeertubeChannelExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.peertube.extractors.PeertubeChannelTabExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.peertube.extractors.PeertubeCommentsExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.peertube.extractors.PeertubePlaylistExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.peertube.extractors.PeertubeSearchExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.peertube.extractors.PeertubeStreamExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.peertube.extractors.PeertubeSuggestionExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.peertube.extractors.PeertubeTrendingExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.peertube.linkHandler.PeertubeChannelLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.services.peertube.linkHandler.PeertubeChannelTabLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.services.peertube.linkHandler.PeertubeCommentsLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.services.peertube.linkHandler.PeertubePlaylistLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.services.peertube.linkHandler.PeertubeSearchQueryHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.services.peertube.linkHandler.PeertubeStreamLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.services.peertube.linkHandler.PeertubeTrendingLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.subscription.SubscriptionExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.suggestion.SuggestionExtractor;

public class PeertubeService
extends StreamingService {
    private PeertubeInstance instance;

    public PeertubeService(int id2) {
        this(id2, PeertubeInstance.DEFAULT_INSTANCE);
    }

    public PeertubeService(int id2, PeertubeInstance instance) {
        super(id2, "PeerTube", Arrays.asList(StreamingService.ServiceInfo.MediaCapability.VIDEO, StreamingService.ServiceInfo.MediaCapability.COMMENTS));
        this.instance = instance;
    }

    @Override
    public LinkHandlerFactory getStreamLHFactory() {
        return PeertubeStreamLinkHandlerFactory.getInstance();
    }

    @Override
    public ListLinkHandlerFactory getChannelLHFactory() {
        return PeertubeChannelLinkHandlerFactory.getInstance();
    }

    @Override
    public ListLinkHandlerFactory getChannelTabLHFactory() {
        return PeertubeChannelTabLinkHandlerFactory.getInstance();
    }

    @Override
    public ListLinkHandlerFactory getPlaylistLHFactory() {
        return PeertubePlaylistLinkHandlerFactory.getInstance();
    }

    @Override
    public SearchQueryHandlerFactory getSearchQHFactory() {
        return PeertubeSearchQueryHandlerFactory.getInstance();
    }

    @Override
    public ListLinkHandlerFactory getCommentsLHFactory() {
        return PeertubeCommentsLinkHandlerFactory.getInstance();
    }

    @Override
    public SearchExtractor getSearchExtractor(SearchQueryHandler queryHandler) {
        List<String> contentFilters = queryHandler.getContentFilters();
        return new PeertubeSearchExtractor(this, queryHandler, !contentFilters.isEmpty() && contentFilters.get(0).startsWith("sepia_"));
    }

    @Override
    public SuggestionExtractor getSuggestionExtractor() {
        return new PeertubeSuggestionExtractor(this);
    }

    @Override
    public SubscriptionExtractor getSubscriptionExtractor() {
        return null;
    }

    @Override
    public ChannelExtractor getChannelExtractor(ListLinkHandler linkHandler) throws ExtractionException {
        if (linkHandler.getUrl().contains("/video-channels/")) {
            return new PeertubeChannelExtractor((StreamingService)this, linkHandler);
        }
        return new PeertubeAccountExtractor((StreamingService)this, linkHandler);
    }

    @Override
    public ChannelTabExtractor getChannelTabExtractor(ListLinkHandler linkHandler) throws ExtractionException {
        return new PeertubeChannelTabExtractor((StreamingService)this, linkHandler);
    }

    @Override
    public PlaylistExtractor getPlaylistExtractor(ListLinkHandler linkHandler) throws ExtractionException {
        return new PeertubePlaylistExtractor((StreamingService)this, linkHandler);
    }

    @Override
    public StreamExtractor getStreamExtractor(LinkHandler linkHandler) throws ExtractionException {
        return new PeertubeStreamExtractor(this, linkHandler);
    }

    @Override
    public CommentsExtractor getCommentsExtractor(ListLinkHandler linkHandler) throws ExtractionException {
        return new PeertubeCommentsExtractor((StreamingService)this, linkHandler);
    }

    @Override
    public String getBaseUrl() {
        return this.instance.getUrl();
    }

    public PeertubeInstance getInstance() {
        return this.instance;
    }

    public void setInstance(PeertubeInstance instance) {
        this.instance = instance;
    }

    @Override
    public KioskList getKioskList() throws ExtractionException {
        PeertubeTrendingLinkHandlerFactory h = PeertubeTrendingLinkHandlerFactory.getInstance();
        KioskList.KioskExtractorFactory kioskFactory = (streamingService, url, id2) -> new PeertubeTrendingExtractor(this, h.fromId(id2), id2);
        KioskList list = new KioskList(this);
        try {
            list.addKioskEntry(kioskFactory, h, "Trending");
            list.addKioskEntry(kioskFactory, h, "Most liked");
            list.addKioskEntry(kioskFactory, h, "Recently added");
            list.addKioskEntry(kioskFactory, h, "Local");
            list.setDefaultKiosk("Trending");
        }
        catch (Exception e) {
            throw new ExtractionException(e);
        }
        return list;
    }
}

