/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.media_ccc.linkHandler;

import java.util.List;
import java.util.regex.Pattern;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandlerFactory;

public final class MediaCCCLiveListLinkHandlerFactory
extends ListLinkHandlerFactory {
    private static final MediaCCCLiveListLinkHandlerFactory INSTANCE = new MediaCCCLiveListLinkHandlerFactory();
    private static final String STREAM_PATTERN = "^(?:https?://)?media\\.ccc\\.de/live$";

    private MediaCCCLiveListLinkHandlerFactory() {
    }

    public static MediaCCCLiveListLinkHandlerFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public String getId(String url) throws ParsingException, UnsupportedOperationException {
        return "live";
    }

    @Override
    public boolean onAcceptUrl(String url) throws ParsingException {
        return Pattern.matches(STREAM_PATTERN, url);
    }

    @Override
    public String getUrl(String id2, List<String> contentFilter, String sortFilter) throws ParsingException, UnsupportedOperationException {
        return "https://media.ccc.de/live";
    }
}

