/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.media_ccc.extractors;

import java.io.IOException;
import java.util.Comparator;
import org.watermedia.shaded.com.grack.nanojson.JsonArray;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.com.grack.nanojson.JsonParser;
import org.watermedia.shaded.com.grack.nanojson.JsonParserException;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.ListExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.Page;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Downloader;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.kiosk.KioskExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.DateWrapper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.media_ccc.extractors.MediaCCCRecentKioskExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamInfoItem;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamInfoItemsCollector;

public class MediaCCCRecentKiosk
extends KioskExtractor<StreamInfoItem> {
    public static final String KIOSK_ID = "recent";
    private JsonObject doc;

    public MediaCCCRecentKiosk(StreamingService streamingService, ListLinkHandler linkHandler, String kioskId) {
        super(streamingService, linkHandler, kioskId);
    }

    @Override
    public void onFetchPage(@Nonnull Downloader downloader) throws IOException, ExtractionException {
        String site = downloader.get("https://api.media.ccc.de/public/events/recent", this.getExtractorLocalization()).responseBody();
        try {
            this.doc = JsonParser.object().from(site);
        }
        catch (JsonParserException jpe) {
            throw new ExtractionException("Could not parse json.", jpe);
        }
    }

    @Override
    @Nonnull
    public ListExtractor.InfoItemsPage<StreamInfoItem> getInitialPage() throws IOException, ExtractionException {
        JsonArray events = this.doc.getArray("events");
        Comparator<StreamInfoItem> comparator = Comparator.comparing(StreamInfoItem::getUploadDate, Comparator.nullsLast(Comparator.comparing(DateWrapper::offsetDateTime))).reversed();
        StreamInfoItemsCollector collector = new StreamInfoItemsCollector(this.getServiceId(), comparator);
        events.stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).map(MediaCCCRecentKioskExtractor::new).filter(extractor -> extractor.getDuration() > 0L).forEach(collector::commit);
        return new ListExtractor.InfoItemsPage<StreamInfoItem>(collector, null);
    }

    @Override
    public ListExtractor.InfoItemsPage<StreamInfoItem> getPage(Page page) throws IOException, ExtractionException {
        return ListExtractor.InfoItemsPage.emptyPage();
    }

    @Override
    @Nonnull
    public String getName() throws ParsingException {
        return KIOSK_ID;
    }
}

