/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.linkHandler;

import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.LinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.extractors.BandcampExtractorHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public final class BandcampStreamLinkHandlerFactory
extends LinkHandlerFactory {
    private static final BandcampStreamLinkHandlerFactory INSTANCE = new BandcampStreamLinkHandlerFactory();

    private BandcampStreamLinkHandlerFactory() {
    }

    public static BandcampStreamLinkHandlerFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public String getId(String url) throws ParsingException, UnsupportedOperationException {
        if (BandcampExtractorHelper.isRadioUrl(url)) {
            return url.split("bandcamp.com/\\?show=")[1];
        }
        return this.getUrl(url);
    }

    @Override
    public String getUrl(String input) throws ParsingException, UnsupportedOperationException {
        if (input.matches("\\d+")) {
            return "https://bandcamp.com/?show=" + input;
        }
        return Utils.replaceHttpWithHttps(input);
    }

    @Override
    public boolean onAcceptUrl(String url) throws ParsingException {
        if (BandcampExtractorHelper.isRadioUrl(url)) {
            return true;
        }
        if (!url.toLowerCase().matches("https?://.+\\..+/track/.+")) {
            return false;
        }
        return BandcampExtractorHelper.isArtistDomain(url);
    }
}

