/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.linkHandler;

import java.io.IOException;
import java.util.List;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.com.grack.nanojson.JsonParserException;
import org.watermedia.shaded.schabi.newpipe.extractor.NewPipe;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ReCaptchaException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.extractors.BandcampExtractorHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.JsonUtils;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public final class BandcampChannelLinkHandlerFactory
extends ListLinkHandlerFactory {
    private static final BandcampChannelLinkHandlerFactory INSTANCE = new BandcampChannelLinkHandlerFactory();

    private BandcampChannelLinkHandlerFactory() {
    }

    public static BandcampChannelLinkHandlerFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public String getId(String url) throws ParsingException, UnsupportedOperationException {
        try {
            String response = NewPipe.getDownloader().get(Utils.replaceHttpWithHttps(url)).responseBody();
            JsonObject bandData = JsonUtils.getJsonData(response, "data-band");
            return String.valueOf(bandData.getLong("id"));
        }
        catch (IOException | ArrayIndexOutOfBoundsException | JsonParserException | ReCaptchaException e) {
            throw new ParsingException("Download failed", e);
        }
    }

    @Override
    public String getUrl(String id2, List<String> contentFilter, String sortFilter) throws ParsingException, UnsupportedOperationException {
        JsonObject artistDetails = BandcampExtractorHelper.getArtistDetails(id2);
        if (artistDetails.getBoolean("error")) {
            throw new ParsingException("JSON does not contain a channel URL (invalid id?) or is otherwise invalid");
        }
        return Utils.replaceHttpWithHttps(artistDetails.getString("bandcamp_url"));
    }

    @Override
    public boolean onAcceptUrl(String url) throws ParsingException {
        String lowercaseUrl = url.toLowerCase();
        String[] splitUrl = lowercaseUrl.split("/");
        if (splitUrl.length != 3 && splitUrl.length != 4) {
            return false;
        }
        if (!(splitUrl.length != 4 || splitUrl[3].equals("releases") || splitUrl[3].equals("music") || splitUrl[3].equals("album") || splitUrl[3].equals("track"))) {
            return false;
        }
        if (splitUrl[2].equals("daily.bandcamp.com")) {
            return false;
        }
        return BandcampExtractorHelper.isArtistDomain(lowercaseUrl);
    }
}

