/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.extractors;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.com.grack.nanojson.JsonParserException;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.jsoup.Jsoup;
import org.watermedia.shaded.jsoup.nodes.Document;
import org.watermedia.shaded.jsoup.nodes.Element;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.MediaFormat;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Downloader;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.PaidContentException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.LinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.DateWrapper;
import org.watermedia.shaded.schabi.newpipe.extractor.playlist.PlaylistInfoItemsCollector;
import org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.extractors.BandcampExtractorHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.extractors.BandcampRelatedPlaylistInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.AudioStream;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.Description;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamType;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.VideoStream;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.JsonUtils;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public class BandcampStreamExtractor
extends StreamExtractor {
    private JsonObject albumJson;
    private JsonObject current;
    private Document document;

    public BandcampStreamExtractor(StreamingService service, LinkHandler linkHandler) {
        super(service, linkHandler);
    }

    @Override
    public void onFetchPage(@Nonnull Downloader downloader) throws IOException, ExtractionException {
        String html = downloader.get(this.getLinkHandler().getUrl()).responseBody();
        this.document = Jsoup.parse(html);
        this.albumJson = BandcampStreamExtractor.getAlbumInfoJson(html);
        this.current = this.albumJson.getObject("current");
        if (this.albumJson.getArray("trackinfo").size() > 1) {
            throw new ExtractionException("Page is actually an album, not a track");
        }
        if (this.albumJson.getArray("trackinfo").getObject(0).isNull("file")) {
            throw new PaidContentException("This track is not available without being purchased");
        }
    }

    public static JsonObject getAlbumInfoJson(String html) throws ParsingException {
        try {
            return JsonUtils.getJsonData(html, "data-tralbum");
        }
        catch (JsonParserException e) {
            throw new ParsingException("Faulty JSON; page likely does not contain album data", e);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ParsingException("JSON does not exist", e);
        }
    }

    @Override
    @Nonnull
    public String getName() throws ParsingException {
        return this.current.getString("title");
    }

    @Override
    @Nonnull
    public String getUploaderUrl() throws ParsingException {
        String[] parts = this.getUrl().split("/");
        return "https://" + parts[2] + "/";
    }

    @Override
    @Nonnull
    public String getUrl() throws ParsingException {
        return Utils.replaceHttpWithHttps(this.albumJson.getString("url"));
    }

    @Override
    @Nonnull
    public String getUploaderName() throws ParsingException {
        return this.albumJson.getString("artist");
    }

    @Override
    @Nullable
    public String getTextualUploadDate() {
        return this.current.getString("publish_date");
    }

    @Override
    @Nullable
    public DateWrapper getUploadDate() throws ParsingException {
        return BandcampExtractorHelper.parseDate(this.getTextualUploadDate());
    }

    @Override
    @Nonnull
    public List<Image> getThumbnails() throws ParsingException {
        if (this.albumJson.isNull("art_id")) {
            return List.of();
        }
        return BandcampExtractorHelper.getImagesFromImageId(this.albumJson.getLong("art_id"), true);
    }

    @Override
    @Nonnull
    public List<Image> getUploaderAvatars() {
        return BandcampExtractorHelper.getImagesFromImageUrl(this.document.getElementsByClass("band-photo").stream().map(element -> element.attr("src")).findFirst().orElse(""));
    }

    @Override
    @Nonnull
    public Description getDescription() {
        String s = Utils.nonEmptyAndNullJoin("\n\n", this.current.getString("about"), this.current.getString("lyrics"), this.current.getString("credits"));
        return new Description(s, 3);
    }

    @Override
    public List<AudioStream> getAudioStreams() {
        return Collections.singletonList(new AudioStream.Builder().setId("mp3-128").setContent(this.albumJson.getArray("trackinfo").getObject(0).getObject("file").getString("mp3-128"), true).setMediaFormat(MediaFormat.MP3).setAverageBitrate(128).build());
    }

    @Override
    public long getLength() throws ParsingException {
        return (long)this.albumJson.getArray("trackinfo").getObject(0).getDouble("duration");
    }

    @Override
    public List<VideoStream> getVideoStreams() {
        return Collections.emptyList();
    }

    @Override
    public List<VideoStream> getVideoOnlyStreams() {
        return Collections.emptyList();
    }

    @Override
    public StreamType getStreamType() {
        return StreamType.AUDIO_STREAM;
    }

    public PlaylistInfoItemsCollector getRelatedItems() {
        PlaylistInfoItemsCollector collector = new PlaylistInfoItemsCollector(this.getServiceId());
        this.document.getElementsByClass("recommended-album").stream().map(BandcampRelatedPlaylistInfoItemExtractor::new).forEach(collector::commit);
        return collector;
    }

    @Override
    @Nonnull
    public String getCategory() {
        return this.document.getElementsByClass("tralbum-tags").stream().flatMap(element -> element.getElementsByClass("tag").stream()).map(Element::text).findFirst().orElse("");
    }

    @Override
    @Nonnull
    public String getLicence() {
        switch (this.current.getInt("license_type")) {
            case 1: {
                return "All rights reserved \u00a9";
            }
            case 2: {
                return "CC BY-NC-ND 3.0";
            }
            case 3: {
                return "CC BY-NC-SA 3.0";
            }
            case 4: {
                return "CC BY-NC 3.0";
            }
            case 5: {
                return "CC BY-ND 3.0";
            }
            case 6: {
                return "CC BY 3.0";
            }
            case 8: {
                return "CC BY-SA 3.0";
            }
        }
        return "Unknown";
    }

    @Override
    @Nonnull
    public List<String> getTags() {
        return this.document.getElementsByAttributeValue("itemprop", "keywords").stream().map(Element::text).collect(Collectors.toList());
    }
}

