/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.extractors;

import java.io.IOException;
import org.watermedia.shaded.com.grack.nanojson.JsonArray;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.InfoItem;
import org.watermedia.shaded.schabi.newpipe.extractor.ListExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.MultiInfoItemsCollector;
import org.watermedia.shaded.schabi.newpipe.extractor.Page;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.channel.tabs.ChannelTabExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Downloader;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.extractors.BandcampAlbumInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.extractors.BandcampExtractorHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.extractors.streaminfoitem.BandcampDiscographStreamInfoItemExtractor;

public class BandcampChannelTabExtractor
extends ChannelTabExtractor {
    private JsonArray discography;
    private final String filter;

    public BandcampChannelTabExtractor(StreamingService service, ListLinkHandler linkHandler) {
        super(service, linkHandler);
        String tab;
        switch (tab = linkHandler.getContentFilters().get(0)) {
            case "tracks": {
                this.filter = "track";
                break;
            }
            case "albums": {
                this.filter = "album";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported channel tab: " + tab);
            }
        }
    }

    public static BandcampChannelTabExtractor fromDiscography(StreamingService service, ListLinkHandler linkHandler, JsonArray discography) {
        BandcampChannelTabExtractor tabExtractor = new BandcampChannelTabExtractor(service, linkHandler);
        tabExtractor.discography = discography;
        return tabExtractor;
    }

    @Override
    public void onFetchPage(@Nonnull Downloader downloader) throws ParsingException {
        if (this.discography == null) {
            this.discography = BandcampExtractorHelper.getArtistDetails(this.getId()).getArray("discography");
        }
    }

    @Override
    @Nonnull
    public ListExtractor.InfoItemsPage<InfoItem> getInitialPage() throws IOException, ExtractionException {
        MultiInfoItemsCollector collector = new MultiInfoItemsCollector(this.getServiceId());
        for (Object discograph : this.discography) {
            JsonObject discographJsonObject;
            String itemType;
            if (!(discograph instanceof JsonObject) || !(itemType = (discographJsonObject = (JsonObject)discograph).getString("item_type", "")).equals(this.filter)) continue;
            switch (itemType) {
                case "track": {
                    collector.commit(new BandcampDiscographStreamInfoItemExtractor(discographJsonObject, this.getUrl()));
                    break;
                }
                case "album": {
                    collector.commit(new BandcampAlbumInfoItemExtractor(discographJsonObject, this.getUrl()));
                }
            }
        }
        return new ListExtractor.InfoItemsPage<InfoItem>(collector, null);
    }

    @Override
    public ListExtractor.InfoItemsPage<InfoItem> getPage(Page page) {
        return null;
    }
}

