/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.extractors;

import java.util.List;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.jsoup.nodes.Element;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.channel.ChannelInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.extractors.BandcampExtractorHelper;

public class BandcampChannelInfoItemExtractor
implements ChannelInfoItemExtractor {
    private final Element resultInfo;
    private final Element searchResult;

    public BandcampChannelInfoItemExtractor(Element searchResult) {
        this.searchResult = searchResult;
        this.resultInfo = searchResult.getElementsByClass("result-info").first();
    }

    @Override
    public String getName() throws ParsingException {
        return this.resultInfo.getElementsByClass("heading").text();
    }

    @Override
    public String getUrl() throws ParsingException {
        return this.resultInfo.getElementsByClass("itemurl").text();
    }

    @Override
    @Nonnull
    public List<Image> getThumbnails() throws ParsingException {
        return BandcampExtractorHelper.getImagesFromSearchResult(this.searchResult);
    }

    @Override
    public String getDescription() {
        return this.resultInfo.getElementsByClass("subhead").text();
    }

    @Override
    public long getSubscriberCount() {
        return -1L;
    }

    @Override
    public long getStreamCount() {
        return -1L;
    }

    @Override
    public boolean isVerified() throws ParsingException {
        return false;
    }
}

