/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.extractors;

import java.util.List;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.playlist.PlaylistInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.extractors.BandcampExtractorHelper;

public class BandcampAlbumInfoItemExtractor
implements PlaylistInfoItemExtractor {
    private final JsonObject albumInfoItem;
    private final String uploaderUrl;

    public BandcampAlbumInfoItemExtractor(JsonObject albumInfoItem, String uploaderUrl) {
        this.albumInfoItem = albumInfoItem;
        this.uploaderUrl = uploaderUrl;
    }

    @Override
    public String getName() throws ParsingException {
        return this.albumInfoItem.getString("title");
    }

    @Override
    public String getUrl() throws ParsingException {
        return BandcampExtractorHelper.getStreamUrlFromIds(this.albumInfoItem.getLong("band_id"), this.albumInfoItem.getLong("item_id"), this.albumInfoItem.getString("item_type"));
    }

    @Override
    @Nonnull
    public List<Image> getThumbnails() throws ParsingException {
        return BandcampExtractorHelper.getImagesFromImageId(this.albumInfoItem.getLong("art_id"), true);
    }

    @Override
    public String getUploaderName() throws ParsingException {
        return this.albumInfoItem.getString("band_name");
    }

    @Override
    public String getUploaderUrl() {
        return this.uploaderUrl;
    }

    @Override
    public boolean isUploaderVerified() {
        return false;
    }

    @Override
    public long getStreamCount() {
        return -1L;
    }
}

