/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.playlist;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.ListExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.ListInfo;
import org.watermedia.shaded.schabi.newpipe.extractor.NewPipe;
import org.watermedia.shaded.schabi.newpipe.extractor.Page;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.playlist.PlaylistExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.Description;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamInfoItem;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.ExtractorHelper;

public final class PlaylistInfo
extends ListInfo<StreamInfoItem> {
    private String uploaderUrl = "";
    private String uploaderName = "";
    private String subChannelUrl;
    private String subChannelName;
    private Description description;
    @Nonnull
    private List<Image> banners = List.of();
    @Nonnull
    private List<Image> subChannelAvatars = List.of();
    @Nonnull
    private List<Image> thumbnails = List.of();
    @Nonnull
    private List<Image> uploaderAvatars = List.of();
    private long streamCount;
    private PlaylistType playlistType;

    private PlaylistInfo(int serviceId, ListLinkHandler linkHandler, String name) throws ParsingException {
        super(serviceId, linkHandler, name);
    }

    public static PlaylistInfo getInfo(String url) throws IOException, ExtractionException {
        return PlaylistInfo.getInfo(NewPipe.getServiceByUrl(url), url);
    }

    public static PlaylistInfo getInfo(StreamingService service, String url) throws IOException, ExtractionException {
        PlaylistExtractor extractor = service.getPlaylistExtractor(url);
        extractor.fetchPage();
        return PlaylistInfo.getInfo(extractor);
    }

    public static ListExtractor.InfoItemsPage<StreamInfoItem> getMoreItems(StreamingService service, String url, Page page) throws IOException, ExtractionException {
        return service.getPlaylistExtractor(url).getPage(page);
    }

    public static PlaylistInfo getInfo(PlaylistExtractor extractor) throws ExtractionException {
        PlaylistInfo info = new PlaylistInfo(extractor.getServiceId(), extractor.getLinkHandler(), extractor.getName());
        ArrayList<Throwable> uploaderParsingErrors = new ArrayList<Throwable>();
        try {
            info.setOriginalUrl(extractor.getOriginalUrl());
        }
        catch (Exception e) {
            info.addError(e);
        }
        try {
            info.setStreamCount(extractor.getStreamCount());
        }
        catch (Exception e) {
            info.addError(e);
        }
        try {
            info.setDescription(extractor.getDescription());
        }
        catch (Exception e) {
            info.addError(e);
        }
        try {
            info.setThumbnails(extractor.getThumbnails());
        }
        catch (Exception e) {
            info.addError(e);
        }
        try {
            info.setUploaderUrl(extractor.getUploaderUrl());
        }
        catch (Exception e) {
            uploaderParsingErrors.add(e);
        }
        try {
            info.setUploaderName(extractor.getUploaderName());
        }
        catch (Exception e) {
            uploaderParsingErrors.add(e);
        }
        try {
            info.setUploaderAvatars(extractor.getUploaderAvatars());
        }
        catch (Exception e) {
            uploaderParsingErrors.add(e);
        }
        try {
            info.setSubChannelUrl(extractor.getSubChannelUrl());
        }
        catch (Exception e) {
            uploaderParsingErrors.add(e);
        }
        try {
            info.setSubChannelName(extractor.getSubChannelName());
        }
        catch (Exception e) {
            uploaderParsingErrors.add(e);
        }
        try {
            info.setSubChannelAvatars(extractor.getSubChannelAvatars());
        }
        catch (Exception e) {
            uploaderParsingErrors.add(e);
        }
        try {
            info.setBanners(extractor.getBanners());
        }
        catch (Exception e) {
            info.addError(e);
        }
        try {
            info.setPlaylistType(extractor.getPlaylistType());
        }
        catch (Exception e) {
            info.addError(e);
        }
        if (!(uploaderParsingErrors.isEmpty() || info.getErrors().isEmpty() && uploaderParsingErrors.size() >= 3)) {
            info.addAllErrors(uploaderParsingErrors);
        }
        ListExtractor.InfoItemsPage<StreamInfoItem> itemsPage = ExtractorHelper.getItemsPageOrLogError(info, extractor);
        info.setRelatedItems(itemsPage.getItems());
        info.setNextPage(itemsPage.getNextPage());
        return info;
    }

    @Nonnull
    public List<Image> getThumbnails() {
        return this.thumbnails;
    }

    public void setThumbnails(@Nonnull List<Image> thumbnails) {
        this.thumbnails = thumbnails;
    }

    @Nonnull
    public List<Image> getBanners() {
        return this.banners;
    }

    public void setBanners(@Nonnull List<Image> banners) {
        this.banners = banners;
    }

    public String getUploaderUrl() {
        return this.uploaderUrl;
    }

    public void setUploaderUrl(String uploaderUrl) {
        this.uploaderUrl = uploaderUrl;
    }

    public String getUploaderName() {
        return this.uploaderName;
    }

    public void setUploaderName(String uploaderName) {
        this.uploaderName = uploaderName;
    }

    @Nonnull
    public List<Image> getUploaderAvatars() {
        return this.uploaderAvatars;
    }

    public void setUploaderAvatars(@Nonnull List<Image> uploaderAvatars) {
        this.uploaderAvatars = uploaderAvatars;
    }

    public String getSubChannelUrl() {
        return this.subChannelUrl;
    }

    public void setSubChannelUrl(String subChannelUrl) {
        this.subChannelUrl = subChannelUrl;
    }

    public String getSubChannelName() {
        return this.subChannelName;
    }

    public void setSubChannelName(String subChannelName) {
        this.subChannelName = subChannelName;
    }

    @Nonnull
    public List<Image> getSubChannelAvatars() {
        return this.subChannelAvatars;
    }

    public void setSubChannelAvatars(@Nonnull List<Image> subChannelAvatars) {
        this.subChannelAvatars = subChannelAvatars;
    }

    public long getStreamCount() {
        return this.streamCount;
    }

    public void setStreamCount(long streamCount) {
        this.streamCount = streamCount;
    }

    public Description getDescription() {
        return this.description;
    }

    public void setDescription(Description description) {
        this.description = description;
    }

    public PlaylistType getPlaylistType() {
        return this.playlistType;
    }

    public void setPlaylistType(PlaylistType playlistType) {
        this.playlistType = playlistType;
    }

    public static enum PlaylistType {
        NORMAL,
        MIX_STREAM,
        MIX_MUSIC,
        MIX_CHANNEL,
        MIX_GENRE;

    }
}

