/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.localization;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.LocaleCompat;

public class Localization
implements Serializable {
    public static final Localization DEFAULT = new Localization("en", "GB");
    @Nonnull
    private final String languageCode;
    @Nullable
    private final String countryCode;

    @Nonnull
    public static List<Localization> listFrom(String ... localizationCodeList) {
        ArrayList<Localization> toReturn = new ArrayList<Localization>();
        for (String localizationCode : localizationCodeList) {
            toReturn.add(Localization.fromLocalizationCode(localizationCode).orElseThrow(() -> new IllegalArgumentException("Not a localization code: " + localizationCode)));
        }
        return Collections.unmodifiableList(toReturn);
    }

    @Nonnull
    public static Optional<Localization> fromLocalizationCode(String localizationCode) {
        return LocaleCompat.forLanguageTag(localizationCode).map(Localization::fromLocale);
    }

    public Localization(@Nonnull String languageCode, @Nullable String countryCode) {
        this.languageCode = languageCode;
        this.countryCode = countryCode;
    }

    public Localization(@Nonnull String languageCode) {
        this(languageCode, null);
    }

    @Nonnull
    public String getLanguageCode() {
        return this.languageCode;
    }

    @Nonnull
    public String getCountryCode() {
        return this.countryCode == null ? "" : this.countryCode;
    }

    public static Localization fromLocale(@Nonnull Locale locale) {
        return new Localization(locale.getLanguage(), locale.getCountry());
    }

    public String getLocalizationCode() {
        return this.languageCode + (String)(this.countryCode == null ? "" : "-" + this.countryCode);
    }

    public String toString() {
        return "Localization[" + this.getLocalizationCode() + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Localization)) {
            return false;
        }
        Localization that = (Localization)o;
        return this.languageCode.equals(that.languageCode) && Objects.equals(this.countryCode, that.countryCode);
    }

    public int hashCode() {
        int result = this.languageCode.hashCode();
        result = 31 * result + Objects.hashCode(this.countryCode);
        return result;
    }

    public static Locale getLocaleFromThreeLetterCode(@Nonnull String code) throws ParsingException {
        String[] languages = Locale.getISOLanguages();
        HashMap<String, Locale> localeMap = new HashMap<String, Locale>(languages.length);
        for (String language : languages) {
            Locale locale = new Locale(language);
            localeMap.put(locale.getISO3Language(), locale);
        }
        if (localeMap.containsKey(code)) {
            return (Locale)localeMap.get(code);
        }
        throw new ParsingException("Could not get Locale from this three letter language code" + code);
    }
}

