/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.kiosk;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.NewPipe;
import org.watermedia.shaded.schabi.newpipe.extractor.Page;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.kiosk.KioskExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.ContentCountry;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.Localization;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public class KioskList {
    private final StreamingService service;
    private final HashMap<String, KioskEntry> kioskList = new HashMap();
    private String defaultKiosk = null;
    @Nullable
    private Localization forcedLocalization;
    @Nullable
    private ContentCountry forcedContentCountry;

    public KioskList(StreamingService service) {
        this.service = service;
    }

    public void addKioskEntry(KioskExtractorFactory extractorFactory, ListLinkHandlerFactory handlerFactory, String id2) throws Exception {
        if (this.kioskList.get(id2) != null) {
            throw new Exception("Kiosk with type " + id2 + " already exists.");
        }
        this.kioskList.put(id2, new KioskEntry(extractorFactory, handlerFactory));
    }

    public void setDefaultKiosk(String kioskType) {
        this.defaultKiosk = kioskType;
    }

    public KioskExtractor getDefaultKioskExtractor() throws ExtractionException, IOException {
        return this.getDefaultKioskExtractor(null);
    }

    public KioskExtractor getDefaultKioskExtractor(Page nextPage) throws ExtractionException, IOException {
        return this.getDefaultKioskExtractor(nextPage, NewPipe.getPreferredLocalization());
    }

    public KioskExtractor getDefaultKioskExtractor(Page nextPage, Localization localization) throws ExtractionException, IOException {
        if (!Utils.isNullOrEmpty(this.defaultKiosk)) {
            return this.getExtractorById(this.defaultKiosk, nextPage, localization);
        }
        String first = this.kioskList.keySet().stream().findAny().orElse(null);
        if (first != null) {
            return this.getExtractorById(first, nextPage, localization);
        }
        return null;
    }

    public String getDefaultKioskId() {
        return this.defaultKiosk;
    }

    public KioskExtractor getExtractorById(String kioskId, Page nextPage) throws ExtractionException, IOException {
        return this.getExtractorById(kioskId, nextPage, NewPipe.getPreferredLocalization());
    }

    public KioskExtractor getExtractorById(String kioskId, Page nextPage, Localization localization) throws ExtractionException, IOException {
        KioskEntry ke = this.kioskList.get(kioskId);
        if (ke == null) {
            throw new ExtractionException("No kiosk found with the type: " + kioskId);
        }
        KioskExtractor kioskExtractor = ke.extractorFactory.createNewKiosk(this.service, ke.handlerFactory.fromId(kioskId).getUrl(), kioskId);
        if (this.forcedLocalization != null) {
            kioskExtractor.forceLocalization(this.forcedLocalization);
        }
        if (this.forcedContentCountry != null) {
            kioskExtractor.forceContentCountry(this.forcedContentCountry);
        }
        return kioskExtractor;
    }

    public Set<String> getAvailableKiosks() {
        return this.kioskList.keySet();
    }

    public KioskExtractor getExtractorByUrl(String url, Page nextPage) throws ExtractionException, IOException {
        return this.getExtractorByUrl(url, nextPage, NewPipe.getPreferredLocalization());
    }

    public KioskExtractor getExtractorByUrl(String url, Page nextPage, Localization localization) throws ExtractionException, IOException {
        for (Map.Entry<String, KioskEntry> e : this.kioskList.entrySet()) {
            KioskEntry ke = e.getValue();
            if (!ke.handlerFactory.acceptUrl(url)) continue;
            return this.getExtractorById(ke.handlerFactory.getId(url), nextPage, localization);
        }
        throw new ExtractionException("Could not find a kiosk that fits to the url: " + url);
    }

    public ListLinkHandlerFactory getListLinkHandlerFactoryByType(String type) {
        return this.kioskList.get((Object)type).handlerFactory;
    }

    public void forceLocalization(@Nullable Localization localization) {
        this.forcedLocalization = localization;
    }

    public void forceContentCountry(@Nullable ContentCountry contentCountry) {
        this.forcedContentCountry = contentCountry;
    }

    private static class KioskEntry {
        final KioskExtractorFactory extractorFactory;
        final ListLinkHandlerFactory handlerFactory;

        KioskEntry(KioskExtractorFactory ef, ListLinkHandlerFactory h) {
            this.extractorFactory = ef;
            this.handlerFactory = h;
        }
    }

    public static interface KioskExtractorFactory {
        public KioskExtractor createNewKiosk(StreamingService var1, String var2, String var3) throws ExtractionException, IOException;
    }
}

