/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.feed;

import java.io.IOException;
import java.util.List;
import org.watermedia.shaded.schabi.newpipe.extractor.ListExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.ListInfo;
import org.watermedia.shaded.schabi.newpipe.extractor.NewPipe;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.feed.FeedExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamInfoItem;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.ExtractorHelper;

public class FeedInfo
extends ListInfo<StreamInfoItem> {
    public FeedInfo(int serviceId, String id2, String url, String originalUrl, String name, List<String> contentFilter, String sortFilter) {
        super(serviceId, id2, url, originalUrl, name, contentFilter, sortFilter);
    }

    public static FeedInfo getInfo(String url) throws IOException, ExtractionException {
        return FeedInfo.getInfo(NewPipe.getServiceByUrl(url), url);
    }

    public static FeedInfo getInfo(StreamingService service, String url) throws IOException, ExtractionException {
        FeedExtractor extractor = service.getFeedExtractor(url);
        if (extractor == null) {
            throw new IllegalArgumentException("Service \"" + service.getServiceInfo().getName() + "\" doesn't support FeedExtractor.");
        }
        extractor.fetchPage();
        return FeedInfo.getInfo(extractor);
    }

    public static FeedInfo getInfo(FeedExtractor extractor) throws IOException, ExtractionException {
        extractor.fetchPage();
        int serviceId = extractor.getServiceId();
        String id2 = extractor.getId();
        String url = extractor.getUrl();
        String originalUrl = extractor.getOriginalUrl();
        String name = extractor.getName();
        FeedInfo info = new FeedInfo(serviceId, id2, url, originalUrl, name, null, null);
        ListExtractor.InfoItemsPage<StreamInfoItem> itemsPage = ExtractorHelper.getItemsPageOrLogError(info, extractor);
        info.setRelatedItems(itemsPage.getItems());
        info.setNextPage(itemsPage.getNextPage());
        return info;
    }
}

