/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.channel.tabs;

import java.io.IOException;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.InfoItem;
import org.watermedia.shaded.schabi.newpipe.extractor.ListExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.ListInfo;
import org.watermedia.shaded.schabi.newpipe.extractor.Page;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.channel.tabs.ChannelTabExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.ExtractorHelper;

public class ChannelTabInfo
extends ListInfo<InfoItem> {
    public ChannelTabInfo(int serviceId, @Nonnull ListLinkHandler linkHandler) {
        super(serviceId, linkHandler, linkHandler.getContentFilters().get(0));
    }

    @Nonnull
    public static ChannelTabInfo getInfo(@Nonnull StreamingService service, @Nonnull ListLinkHandler linkHandler) throws ExtractionException, IOException {
        ChannelTabExtractor extractor = service.getChannelTabExtractor(linkHandler);
        extractor.fetchPage();
        return ChannelTabInfo.getInfo(extractor);
    }

    @Nonnull
    public static ChannelTabInfo getInfo(@Nonnull ChannelTabExtractor extractor) {
        ChannelTabInfo info = new ChannelTabInfo(extractor.getServiceId(), extractor.getLinkHandler());
        try {
            info.setOriginalUrl(extractor.getOriginalUrl());
        }
        catch (Exception e) {
            info.addError(e);
        }
        ListExtractor.InfoItemsPage<InfoItem> page = ExtractorHelper.getItemsPageOrLogError(info, extractor);
        info.setRelatedItems(page.getItems());
        info.setNextPage(page.getNextPage());
        return info;
    }

    public static ListExtractor.InfoItemsPage<InfoItem> getMoreItems(@Nonnull StreamingService service, @Nonnull ListLinkHandler linkHandler, @Nonnull Page page) throws ExtractionException, IOException {
        return service.getChannelTabExtractor(linkHandler).getPage(page);
    }
}

