/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.channel;

import java.io.IOException;
import java.util.List;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.Info;
import org.watermedia.shaded.schabi.newpipe.extractor.NewPipe;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.channel.ChannelExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandler;

public class ChannelInfo
extends Info {
    private String parentChannelName;
    private String parentChannelUrl;
    private String feedUrl;
    private long subscriberCount = -1L;
    private String description;
    private String[] donationLinks;
    @Nonnull
    private List<Image> avatars = List.of();
    @Nonnull
    private List<Image> banners = List.of();
    @Nonnull
    private List<Image> parentChannelAvatars = List.of();
    private boolean verified;
    private List<ListLinkHandler> tabs = List.of();
    private List<String> tags = List.of();

    public ChannelInfo(int serviceId, String id2, String url, String originalUrl, String name) {
        super(serviceId, id2, url, originalUrl, name);
    }

    public static ChannelInfo getInfo(String url) throws IOException, ExtractionException {
        return ChannelInfo.getInfo(NewPipe.getServiceByUrl(url), url);
    }

    public static ChannelInfo getInfo(StreamingService service, String url) throws IOException, ExtractionException {
        ChannelExtractor extractor = service.getChannelExtractor(url);
        extractor.fetchPage();
        return ChannelInfo.getInfo(extractor);
    }

    public static ChannelInfo getInfo(ChannelExtractor extractor) throws IOException, ExtractionException {
        int serviceId = extractor.getServiceId();
        String id2 = extractor.getId();
        String url = extractor.getUrl();
        String originalUrl = extractor.getOriginalUrl();
        String name = extractor.getName();
        ChannelInfo info = new ChannelInfo(serviceId, id2, url, originalUrl, name);
        try {
            info.setAvatars(extractor.getAvatars());
        }
        catch (Exception e) {
            info.addError(e);
        }
        try {
            info.setBanners(extractor.getBanners());
        }
        catch (Exception e) {
            info.addError(e);
        }
        try {
            info.setFeedUrl(extractor.getFeedUrl());
        }
        catch (Exception e) {
            info.addError(e);
        }
        try {
            info.setSubscriberCount(extractor.getSubscriberCount());
        }
        catch (Exception e) {
            info.addError(e);
        }
        try {
            info.setDescription(extractor.getDescription());
        }
        catch (Exception e) {
            info.addError(e);
        }
        try {
            info.setParentChannelName(extractor.getParentChannelName());
        }
        catch (Exception e) {
            info.addError(e);
        }
        try {
            info.setParentChannelUrl(extractor.getParentChannelUrl());
        }
        catch (Exception e) {
            info.addError(e);
        }
        try {
            info.setParentChannelAvatars(extractor.getParentChannelAvatars());
        }
        catch (Exception e) {
            info.addError(e);
        }
        try {
            info.setVerified(extractor.isVerified());
        }
        catch (Exception e) {
            info.addError(e);
        }
        try {
            info.setTabs(extractor.getTabs());
        }
        catch (Exception e) {
            info.addError(e);
        }
        try {
            info.setTags(extractor.getTags());
        }
        catch (Exception e) {
            info.addError(e);
        }
        return info;
    }

    public String getParentChannelName() {
        return this.parentChannelName;
    }

    public void setParentChannelName(String parentChannelName) {
        this.parentChannelName = parentChannelName;
    }

    public String getParentChannelUrl() {
        return this.parentChannelUrl;
    }

    public void setParentChannelUrl(String parentChannelUrl) {
        this.parentChannelUrl = parentChannelUrl;
    }

    @Nonnull
    public List<Image> getParentChannelAvatars() {
        return this.parentChannelAvatars;
    }

    public void setParentChannelAvatars(@Nonnull List<Image> parentChannelAvatars) {
        this.parentChannelAvatars = parentChannelAvatars;
    }

    @Nonnull
    public List<Image> getAvatars() {
        return this.avatars;
    }

    public void setAvatars(@Nonnull List<Image> avatars) {
        this.avatars = avatars;
    }

    @Nonnull
    public List<Image> getBanners() {
        return this.banners;
    }

    public void setBanners(@Nonnull List<Image> banners) {
        this.banners = banners;
    }

    public String getFeedUrl() {
        return this.feedUrl;
    }

    public void setFeedUrl(String feedUrl) {
        this.feedUrl = feedUrl;
    }

    public long getSubscriberCount() {
        return this.subscriberCount;
    }

    public void setSubscriberCount(long subscriberCount) {
        this.subscriberCount = subscriberCount;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String[] getDonationLinks() {
        return this.donationLinks;
    }

    public void setDonationLinks(String[] donationLinks) {
        this.donationLinks = donationLinks;
    }

    public boolean isVerified() {
        return this.verified;
    }

    public void setVerified(boolean verified) {
        this.verified = verified;
    }

    @Nonnull
    public List<ListLinkHandler> getTabs() {
        return this.tabs;
    }

    public void setTabs(@Nonnull List<ListLinkHandler> tabs) {
        this.tabs = tabs;
    }

    @Nonnull
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(@Nonnull List<String> tags) {
        this.tags = tags;
    }
}

