/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor;

import java.util.Collections;
import java.util.List;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.NewPipe;
import org.watermedia.shaded.schabi.newpipe.extractor.channel.ChannelExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.channel.tabs.ChannelTabExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.comments.CommentsExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.feed.FeedExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.kiosk.KioskList;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.LinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.LinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.SearchQueryHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.SearchQueryHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.ContentCountry;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.Localization;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.TimeAgoParser;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.TimeAgoPatternsManager;
import org.watermedia.shaded.schabi.newpipe.extractor.playlist.PlaylistExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.search.SearchExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.subscription.SubscriptionExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.suggestion.SuggestionExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public abstract class StreamingService {
    private final int serviceId;
    private final ServiceInfo serviceInfo;

    public StreamingService(int id2, String name, List<ServiceInfo.MediaCapability> capabilities) {
        this.serviceId = id2;
        this.serviceInfo = new ServiceInfo(name, capabilities);
    }

    public final int getServiceId() {
        return this.serviceId;
    }

    public ServiceInfo getServiceInfo() {
        return this.serviceInfo;
    }

    public String toString() {
        return this.serviceId + ":" + this.serviceInfo.getName();
    }

    public abstract String getBaseUrl();

    public abstract LinkHandlerFactory getStreamLHFactory();

    public abstract ListLinkHandlerFactory getChannelLHFactory();

    public abstract ListLinkHandlerFactory getChannelTabLHFactory();

    public abstract ListLinkHandlerFactory getPlaylistLHFactory();

    public abstract SearchQueryHandlerFactory getSearchQHFactory();

    public abstract ListLinkHandlerFactory getCommentsLHFactory();

    public abstract SearchExtractor getSearchExtractor(SearchQueryHandler var1);

    public abstract SuggestionExtractor getSuggestionExtractor();

    public abstract SubscriptionExtractor getSubscriptionExtractor();

    @Nullable
    public FeedExtractor getFeedExtractor(String url) throws ExtractionException {
        return null;
    }

    public abstract KioskList getKioskList() throws ExtractionException;

    public abstract ChannelExtractor getChannelExtractor(ListLinkHandler var1) throws ExtractionException;

    public abstract ChannelTabExtractor getChannelTabExtractor(ListLinkHandler var1) throws ExtractionException;

    public abstract PlaylistExtractor getPlaylistExtractor(ListLinkHandler var1) throws ExtractionException;

    public abstract StreamExtractor getStreamExtractor(LinkHandler var1) throws ExtractionException;

    public abstract CommentsExtractor getCommentsExtractor(ListLinkHandler var1) throws ExtractionException;

    public SearchExtractor getSearchExtractor(String query, List<String> contentFilter, String sortFilter) throws ExtractionException {
        return this.getSearchExtractor((SearchQueryHandler)this.getSearchQHFactory().fromQuery(query, (List)contentFilter, sortFilter));
    }

    public ChannelExtractor getChannelExtractor(String id2, List<String> contentFilter, String sortFilter) throws ExtractionException {
        return this.getChannelExtractor(this.getChannelLHFactory().fromQuery(id2, contentFilter, sortFilter));
    }

    public PlaylistExtractor getPlaylistExtractor(String id2, List<String> contentFilter, String sortFilter) throws ExtractionException {
        return this.getPlaylistExtractor(this.getPlaylistLHFactory().fromQuery(id2, contentFilter, sortFilter));
    }

    public SearchExtractor getSearchExtractor(String query) throws ExtractionException {
        return this.getSearchExtractor(this.getSearchQHFactory().fromQuery(query));
    }

    public ChannelExtractor getChannelExtractor(String url) throws ExtractionException {
        return this.getChannelExtractor(this.getChannelLHFactory().fromUrl(url));
    }

    public ChannelTabExtractor getChannelTabExtractorFromId(String id2, String tab) throws ExtractionException {
        return this.getChannelTabExtractor(this.getChannelTabLHFactory().fromQuery(id2, Collections.singletonList(tab), ""));
    }

    public ChannelTabExtractor getChannelTabExtractorFromIdAndBaseUrl(String id2, String tab, String baseUrl) throws ExtractionException {
        return this.getChannelTabExtractor(this.getChannelTabLHFactory().fromQuery(id2, Collections.singletonList(tab), "", baseUrl));
    }

    public PlaylistExtractor getPlaylistExtractor(String url) throws ExtractionException {
        return this.getPlaylistExtractor(this.getPlaylistLHFactory().fromUrl(url));
    }

    public StreamExtractor getStreamExtractor(String url) throws ExtractionException {
        return this.getStreamExtractor(this.getStreamLHFactory().fromUrl(url));
    }

    public CommentsExtractor getCommentsExtractor(String url) throws ExtractionException {
        ListLinkHandlerFactory listLinkHandlerFactory = this.getCommentsLHFactory();
        if (listLinkHandlerFactory == null) {
            return null;
        }
        return this.getCommentsExtractor(listLinkHandlerFactory.fromUrl(url));
    }

    public final LinkType getLinkTypeByUrl(String url) throws ParsingException {
        String polishedUrl = Utils.followGoogleRedirectIfNeeded(url);
        LinkHandlerFactory sH = this.getStreamLHFactory();
        ListLinkHandlerFactory cH = this.getChannelLHFactory();
        ListLinkHandlerFactory pH = this.getPlaylistLHFactory();
        if (sH != null && sH.acceptUrl(polishedUrl)) {
            return LinkType.STREAM;
        }
        if (cH != null && cH.acceptUrl(polishedUrl)) {
            return LinkType.CHANNEL;
        }
        if (pH != null && pH.acceptUrl(polishedUrl)) {
            return LinkType.PLAYLIST;
        }
        return LinkType.NONE;
    }

    public List<Localization> getSupportedLocalizations() {
        return Collections.singletonList(Localization.DEFAULT);
    }

    public List<ContentCountry> getSupportedCountries() {
        return Collections.singletonList(ContentCountry.DEFAULT);
    }

    public Localization getLocalization() {
        Localization preferredLocalization = NewPipe.getPreferredLocalization();
        if (this.getSupportedLocalizations().contains(preferredLocalization)) {
            return preferredLocalization;
        }
        for (Localization supportedLanguage : this.getSupportedLocalizations()) {
            if (!supportedLanguage.getLanguageCode().equals(preferredLocalization.getLanguageCode())) continue;
            return supportedLanguage;
        }
        return Localization.DEFAULT;
    }

    public ContentCountry getContentCountry() {
        ContentCountry preferredContentCountry = NewPipe.getPreferredContentCountry();
        if (this.getSupportedCountries().contains(preferredContentCountry)) {
            return preferredContentCountry;
        }
        return ContentCountry.DEFAULT;
    }

    public TimeAgoParser getTimeAgoParser(Localization localization) {
        Localization lessSpecificLocalization;
        TimeAgoParser lessSpecificParser;
        TimeAgoParser targetParser = TimeAgoPatternsManager.getTimeAgoParserFor(localization);
        if (targetParser != null) {
            return targetParser;
        }
        if (!localization.getCountryCode().isEmpty() && (lessSpecificParser = TimeAgoPatternsManager.getTimeAgoParserFor(lessSpecificLocalization = new Localization(localization.getLanguageCode()))) != null) {
            return lessSpecificParser;
        }
        throw new IllegalArgumentException("Localization is not supported (\"" + localization + "\")");
    }

    public static enum LinkType {
        NONE,
        STREAM,
        CHANNEL,
        PLAYLIST;

    }

    public static class ServiceInfo {
        private final String name;
        private final List<MediaCapability> mediaCapabilities;

        public ServiceInfo(String name, List<MediaCapability> mediaCapabilities) {
            this.name = name;
            this.mediaCapabilities = Collections.unmodifiableList(mediaCapabilities);
        }

        public String getName() {
            return this.name;
        }

        public List<MediaCapability> getMediaCapabilities() {
            return this.mediaCapabilities;
        }

        public static enum MediaCapability {
            AUDIO,
            VIDEO,
            LIVE,
            COMMENTS;

        }
    }
}

