/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public class Page
implements Serializable {
    private final String url;
    private final String id;
    private final List<String> ids;
    private final Map<String, String> cookies;
    @Nullable
    private final byte[] body;

    public Page(String url, String id2, List<String> ids, Map<String, String> cookies, @Nullable byte[] body) {
        this.url = url;
        this.id = id2;
        this.ids = ids;
        this.cookies = cookies;
        this.body = body;
    }

    public Page(String url) {
        this(url, null, null, null, null);
    }

    public Page(String url, String id2) {
        this(url, id2, null, null, null);
    }

    public Page(String url, String id2, byte[] body) {
        this(url, id2, null, null, body);
    }

    public Page(String url, byte[] body) {
        this(url, null, null, null, body);
    }

    public Page(String url, Map<String, String> cookies) {
        this(url, null, null, cookies, null);
    }

    public Page(List<String> ids) {
        this(null, null, ids, null, null);
    }

    public Page(List<String> ids, Map<String, String> cookies) {
        this(null, null, ids, cookies, null);
    }

    public String getUrl() {
        return this.url;
    }

    public String getId() {
        return this.id;
    }

    public List<String> getIds() {
        return this.ids;
    }

    public Map<String, String> getCookies() {
        return this.cookies;
    }

    public static boolean isValid(Page page) {
        return page != null && (!Utils.isNullOrEmpty(page.getUrl()) || !Utils.isNullOrEmpty(page.getIds()));
    }

    @Nullable
    public byte[] getBody() {
        return this.body;
    }
}

