/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor;

import java.util.List;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.ServiceList;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Downloader;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.ContentCountry;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.Localization;

public final class NewPipe {
    private static Downloader downloader;
    private static Localization preferredLocalization;
    private static ContentCountry preferredContentCountry;

    private NewPipe() {
    }

    public static void init(Downloader d) {
        NewPipe.init(d, Localization.DEFAULT);
    }

    public static void init(Downloader d, Localization l) {
        NewPipe.init(d, l, l.getCountryCode().isEmpty() ? ContentCountry.DEFAULT : new ContentCountry(l.getCountryCode()));
    }

    public static void init(Downloader d, Localization l, ContentCountry c) {
        downloader = d;
        preferredLocalization = l;
        preferredContentCountry = c;
    }

    public static Downloader getDownloader() {
        return downloader;
    }

    public static List<StreamingService> getServices() {
        return ServiceList.all();
    }

    public static StreamingService getService(int serviceId) throws ExtractionException {
        return ServiceList.all().stream().filter(service -> service.getServiceId() == serviceId).findFirst().orElseThrow(() -> new ExtractionException("There's no service with the id = \"" + serviceId + "\""));
    }

    public static StreamingService getService(String serviceName) throws ExtractionException {
        return ServiceList.all().stream().filter(service -> service.getServiceInfo().getName().equals(serviceName)).findFirst().orElseThrow(() -> new ExtractionException("There's no service with the name = \"" + serviceName + "\""));
    }

    public static StreamingService getServiceByUrl(String url) throws ExtractionException {
        for (StreamingService service : ServiceList.all()) {
            if (service.getLinkTypeByUrl(url) == StreamingService.LinkType.NONE) continue;
            return service;
        }
        throw new ExtractionException("No service can handle the url = \"" + url + "\"");
    }

    public static void setupLocalization(Localization thePreferredLocalization) {
        NewPipe.setupLocalization(thePreferredLocalization, null);
    }

    public static void setupLocalization(Localization thePreferredLocalization, @Nullable ContentCountry thePreferredContentCountry) {
        preferredLocalization = thePreferredLocalization;
        preferredContentCountry = thePreferredContentCountry != null ? thePreferredContentCountry : (thePreferredLocalization.getCountryCode().isEmpty() ? ContentCountry.DEFAULT : new ContentCountry(thePreferredLocalization.getCountryCode()));
    }

    @Nonnull
    public static Localization getPreferredLocalization() {
        return preferredLocalization == null ? Localization.DEFAULT : preferredLocalization;
    }

    public static void setPreferredLocalization(Localization preferredLocalization) {
        NewPipe.preferredLocalization = preferredLocalization;
    }

    @Nonnull
    public static ContentCountry getPreferredContentCountry() {
        return preferredContentCountry == null ? ContentCountry.DEFAULT : preferredContentCountry;
    }

    public static void setPreferredContentCountry(ContentCountry preferredContentCountry) {
        NewPipe.preferredContentCountry = preferredContentCountry;
    }
}

