/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.Collector;
import org.watermedia.shaded.schabi.newpipe.extractor.InfoItem;
import org.watermedia.shaded.schabi.newpipe.extractor.InfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.FoundAdException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;

public abstract class InfoItemsCollector<I extends InfoItem, E extends InfoItemExtractor>
implements Collector<I, E> {
    private final List<I> itemList = new ArrayList<I>();
    private final List<Throwable> errors = new ArrayList<Throwable>();
    private final int serviceId;
    @Nullable
    private final Comparator<I> comparator;

    public InfoItemsCollector(int serviceId) {
        this(serviceId, null);
    }

    public InfoItemsCollector(int serviceId, @Nullable Comparator<I> comparator) {
        this.serviceId = serviceId;
        this.comparator = comparator;
    }

    @Override
    public List<I> getItems() {
        if (this.comparator != null) {
            this.itemList.sort(this.comparator);
        }
        return Collections.unmodifiableList(this.itemList);
    }

    @Override
    public List<Throwable> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    @Override
    public void reset() {
        this.itemList.clear();
        this.errors.clear();
    }

    protected void addError(Exception error) {
        this.errors.add(error);
    }

    protected void addItem(I item) {
        this.itemList.add(item);
    }

    public int getServiceId() {
        return this.serviceId;
    }

    @Override
    public void commit(E extractor) {
        try {
            this.addItem((InfoItem)this.extract(extractor));
        }
        catch (FoundAdException foundAdException) {
        }
        catch (ParsingException e) {
            this.addError(e);
        }
    }
}

