/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.mozilla.javascript.optimizer;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Objects;
import jdk.dynalink.StandardNamespace;
import jdk.dynalink.StandardOperation;
import jdk.dynalink.linker.GuardedInvocation;
import jdk.dynalink.linker.LinkRequest;
import jdk.dynalink.linker.LinkerServices;
import jdk.dynalink.linker.TypeBasedGuardingDynamicLinker;
import jdk.dynalink.linker.support.Guards;
import org.watermedia.shaded.mozilla.javascript.ConsString;
import org.watermedia.shaded.mozilla.javascript.Context;
import org.watermedia.shaded.mozilla.javascript.Scriptable;
import org.watermedia.shaded.mozilla.javascript.optimizer.DefaultLinker;
import org.watermedia.shaded.mozilla.javascript.optimizer.ParsedOperation;
import org.watermedia.shaded.mozilla.javascript.optimizer.RhinoNamespace;
import org.watermedia.shaded.mozilla.javascript.optimizer.RhinoOperation;

class StringLinker
implements TypeBasedGuardingDynamicLinker {
    StringLinker() {
    }

    @Override
    public boolean canLinkType(Class<?> type) {
        return String.class.equals(type);
    }

    @Override
    public GuardedInvocation getGuardedInvocation(LinkRequest req, LinkerServices svc) throws Exception {
        if (req.isCallSiteUnstable()) {
            return null;
        }
        Object arg2 = null;
        if (req.getArguments().length > 1) {
            arg2 = req.getArguments()[1];
        }
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        ParsedOperation op = new ParsedOperation(req.getCallSiteDescriptor().getOperation());
        MethodType mType = req.getCallSiteDescriptor().getMethodType();
        MethodHandle mh = null;
        MethodHandle guard = null;
        if (op.isNamespace(RhinoNamespace.MATH)) {
            if (op.isOperation(RhinoOperation.ADD)) {
                MethodType guardType = mType.changeReturnType(Boolean.TYPE);
                if (arg2 instanceof CharSequence) {
                    mh = lookup.findStatic(StringLinker.class, "add", mType);
                    guard = lookup.findStatic(StringLinker.class, "testAdd", guardType);
                }
            } else if (op.isOperation(RhinoOperation.EQ, RhinoOperation.SHALLOWEQ) && arg2 instanceof String) {
                mh = lookup.findStatic(StringLinker.class, "eq", mType);
                guard = lookup.findStatic(StringLinker.class, "testEq", mType);
            }
        } else if (op.isNamespace(StandardNamespace.PROPERTY) && op.isOperation(StandardOperation.GET, RhinoOperation.GETNOWARN) && "length".equals(op.getName())) {
            mh = lookup.findStatic(StringLinker.class, "getLength", mType);
            guard = Guards.getInstanceOfGuard(String.class);
        }
        if (mh != null) {
            assert (guard != null);
            if (DefaultLinker.DEBUG) {
                System.out.println(String.valueOf(op) + " string operation");
            }
            return new GuardedInvocation(mh, guard);
        }
        return null;
    }

    private static boolean testAdd(Object lval, Object rval, Context cx) {
        return lval instanceof String && rval instanceof CharSequence;
    }

    private static Object add(Object lval, Object rval, Context cx) {
        return new ConsString((String)lval, ((CharSequence)rval).toString());
    }

    private static boolean testEq(Object lVal, Object rval) {
        return lVal instanceof String && rval instanceof String;
    }

    private static boolean eq(Object lVal, Object rval) {
        return Objects.equals(lVal, rval);
    }

    private static Object getLength(Object o, Context cx, Scriptable scope) {
        return ((String)o).length();
    }
}

