/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.mozilla.javascript.optimizer;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import jdk.dynalink.linker.GuardedInvocation;
import jdk.dynalink.linker.LinkRequest;
import jdk.dynalink.linker.LinkerServices;
import jdk.dynalink.linker.TypeBasedGuardingDynamicLinker;
import jdk.dynalink.linker.support.Guards;
import org.watermedia.shaded.mozilla.javascript.Context;
import org.watermedia.shaded.mozilla.javascript.ScriptRuntime;
import org.watermedia.shaded.mozilla.javascript.optimizer.DefaultLinker;
import org.watermedia.shaded.mozilla.javascript.optimizer.ParsedOperation;
import org.watermedia.shaded.mozilla.javascript.optimizer.RhinoNamespace;
import org.watermedia.shaded.mozilla.javascript.optimizer.RhinoOperation;

class DoubleLinker
implements TypeBasedGuardingDynamicLinker {
    DoubleLinker() {
    }

    @Override
    public boolean canLinkType(Class<?> type) {
        return Double.class.equals(type);
    }

    @Override
    public GuardedInvocation getGuardedInvocation(LinkRequest req, LinkerServices svc) throws Exception {
        if (req.isCallSiteUnstable()) {
            return null;
        }
        ParsedOperation op = new ParsedOperation(req.getCallSiteDescriptor().getOperation());
        MethodHandle mh = null;
        MethodHandle guard = null;
        if (op.isNamespace(RhinoNamespace.MATH)) {
            Object arg2 = null;
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodType mType = req.getCallSiteDescriptor().getMethodType();
            if (req.getArguments().length > 1) {
                arg2 = req.getArguments()[1];
            }
            if (op.isOperation(RhinoOperation.ADD) && arg2 instanceof Double) {
                mh = lookup.findStatic(DoubleLinker.class, "add", mType);
                MethodType guardType = mType.changeReturnType(Boolean.TYPE);
                guard = lookup.findStatic(DoubleLinker.class, "testAdd", guardType);
            } else if (op.isOperation(RhinoOperation.ADD) && arg2 instanceof Integer) {
                mh = lookup.findStatic(DoubleLinker.class, "addInt", mType);
                MethodType guardType = mType.changeReturnType(Boolean.TYPE);
                guard = lookup.findStatic(DoubleLinker.class, "testAddInt", guardType);
            } else if (op.isOperation(RhinoOperation.EQ, RhinoOperation.SHALLOWEQ) && arg2 instanceof Double) {
                mh = lookup.findStatic(DoubleLinker.class, "eq", mType);
                guard = lookup.findStatic(DoubleLinker.class, "testTwo", mType);
            } else if (op.isOperation(RhinoOperation.EQ, RhinoOperation.SHALLOWEQ) && arg2 instanceof Integer) {
                mh = lookup.findStatic(DoubleLinker.class, "eqInt", mType);
                guard = lookup.findStatic(DoubleLinker.class, "testTwoInt", mType);
            } else if (op.isOperation(RhinoOperation.COMPARE_LT) && arg2 instanceof Double) {
                mh = lookup.findStatic(DoubleLinker.class, "org.watermedia.shaded.compareLT", mType);
                guard = lookup.findStatic(DoubleLinker.class, "testTwo", mType);
            } else if (op.isOperation(RhinoOperation.COMPARE_GT) && arg2 instanceof Double) {
                mh = lookup.findStatic(DoubleLinker.class, "org.watermedia.shaded.compareGT", mType);
                guard = lookup.findStatic(DoubleLinker.class, "testTwo", mType);
            } else if (op.isOperation(RhinoOperation.COMPARE_LE) && arg2 instanceof Double) {
                mh = lookup.findStatic(DoubleLinker.class, "org.watermedia.shaded.compareLE", mType);
                guard = lookup.findStatic(DoubleLinker.class, "testTwo", mType);
            } else if (op.isOperation(RhinoOperation.COMPARE_GE) && arg2 instanceof Double) {
                mh = lookup.findStatic(DoubleLinker.class, "org.watermedia.shaded.compareGE", mType);
                guard = lookup.findStatic(DoubleLinker.class, "testTwo", mType);
            } else if (op.isOperation(RhinoOperation.COMPARE_LT) && arg2 instanceof Integer) {
                mh = lookup.findStatic(DoubleLinker.class, "org.watermedia.shaded.compareLTInt", mType);
                guard = lookup.findStatic(DoubleLinker.class, "testTwoInt", mType);
            } else if (op.isOperation(RhinoOperation.COMPARE_GT) && arg2 instanceof Integer) {
                mh = lookup.findStatic(DoubleLinker.class, "org.watermedia.shaded.compareGTInt", mType);
                guard = lookup.findStatic(DoubleLinker.class, "testTwoInt", mType);
            } else if (op.isOperation(RhinoOperation.COMPARE_LE) && arg2 instanceof Integer) {
                mh = lookup.findStatic(DoubleLinker.class, "org.watermedia.shaded.compareLEInt", mType);
                guard = lookup.findStatic(DoubleLinker.class, "testTwoInt", mType);
            } else if (op.isOperation(RhinoOperation.COMPARE_GE) && arg2 instanceof Integer) {
                mh = lookup.findStatic(DoubleLinker.class, "org.watermedia.shaded.compareGEInt", mType);
                guard = lookup.findStatic(DoubleLinker.class, "testTwoInt", mType);
            } else if (op.isOperation(RhinoOperation.TOBOOLEAN)) {
                mh = lookup.findStatic(DoubleLinker.class, "toBoolean", mType);
                guard = Guards.getInstanceOfGuard(Double.class);
            } else if (op.isOperation(RhinoOperation.TONUMBER)) {
                mh = lookup.findStatic(DoubleLinker.class, "toNumber", mType);
                guard = Guards.getInstanceOfGuard(Double.class);
            } else if (op.isOperation(RhinoOperation.TONUMERIC)) {
                mh = lookup.findStatic(DoubleLinker.class, "toNumeric", mType);
                guard = Guards.getInstanceOfGuard(Double.class);
            } else if (op.isOperation(RhinoOperation.TOINT32)) {
                mh = lookup.findStatic(DoubleLinker.class, "toInt32", mType);
                guard = Guards.getInstanceOfGuard(Double.class);
            } else if (op.isOperation(RhinoOperation.TOUINT32)) {
                mh = lookup.findStatic(DoubleLinker.class, "toUint32", mType);
                guard = Guards.getInstanceOfGuard(Double.class);
            }
        }
        if (mh != null) {
            assert (guard != null);
            if (DefaultLinker.DEBUG) {
                System.out.println(String.valueOf(op) + " double operation");
            }
            return new GuardedInvocation(mh, guard);
        }
        return null;
    }

    private static boolean testAdd(Object lval, Object rval, Context cx) {
        return lval instanceof Double && rval instanceof Double;
    }

    private static Object add(Object lval, Object rval, Context cx) {
        return (Double)lval + (Double)rval;
    }

    private static boolean testAddInt(Object lval, Object rval, Context cx) {
        return lval instanceof Double && rval instanceof Integer;
    }

    private static Object addInt(Object lval, Object rval, Context cx) {
        return (Double)lval + (double)((Integer)rval).intValue();
    }

    private static boolean testTwo(Object lval, Object rval) {
        return lval instanceof Double && rval instanceof Double;
    }

    private static boolean testTwoInt(Object lval, Object rval) {
        return lval instanceof Double && rval instanceof Integer;
    }

    private static boolean eq(Object lval, Object rval) {
        return ((Double)lval).doubleValue() == ((Double)rval).doubleValue();
    }

    private static boolean eqInt(Object lval, Object rval) {
        return ((Double)lval).doubleValue() == ((Integer)rval).doubleValue();
    }

    private static boolean compareLT(Object lval, Object rval) {
        return (Double)lval < (Double)rval;
    }

    private static boolean compareGT(Object lval, Object rval) {
        return (Double)lval > (Double)rval;
    }

    private static boolean compareLE(Object lval, Object rval) {
        return (Double)lval <= (Double)rval;
    }

    private static boolean compareGE(Object lval, Object rval) {
        return (Double)lval >= (Double)rval;
    }

    private static boolean compareLTInt(Object lval, Object rval) {
        return (Double)lval < ((Integer)rval).doubleValue();
    }

    private static boolean compareGTInt(Object lval, Object rval) {
        return (Double)lval > ((Integer)rval).doubleValue();
    }

    private static boolean compareLEInt(Object lval, Object rval) {
        return (Double)lval <= ((Integer)rval).doubleValue();
    }

    private static boolean compareGEInt(Object lval, Object rval) {
        return (Double)lval >= ((Integer)rval).doubleValue();
    }

    private static double toNumber(Object raw) {
        return (Double)raw;
    }

    private static Number toNumeric(Object raw) {
        return (Double)raw;
    }

    private static boolean toBoolean(Object raw) {
        double v = (Double)raw;
        if (Double.isNaN(v)) {
            return false;
        }
        return v != 0.0;
    }

    private static int toInt32(Object raw) {
        return ScriptRuntime.toInt32((Double)raw);
    }

    private static long toUint32(Object raw) {
        return ScriptRuntime.toUint32((Double)raw);
    }
}

