/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.mozilla.javascript.ast;

import org.watermedia.shaded.mozilla.javascript.ast.AstNode;
import org.watermedia.shaded.mozilla.javascript.ast.Jump;
import org.watermedia.shaded.mozilla.javascript.ast.Name;
import org.watermedia.shaded.mozilla.javascript.ast.NodeVisitor;

public class BreakStatement
extends Jump {
    private Name breakLabel;
    private AstNode targetNode;

    public BreakStatement() {
        this.type = 133;
    }

    public BreakStatement(int pos) {
        this.type = 133;
        this.position = pos;
    }

    public BreakStatement(int pos, int len) {
        this.type = 133;
        this.position = pos;
        this.length = len;
    }

    public Name getBreakLabel() {
        return this.breakLabel;
    }

    public void setBreakLabel(Name label) {
        this.breakLabel = label;
        if (label != null) {
            label.setParent(this);
        }
    }

    public AstNode getBreakTarget() {
        return this.targetNode;
    }

    public void setBreakTarget(Jump target) {
        this.assertNotNull(target);
        this.targetNode = target;
        this.setJumpStatement(target);
    }

    @Override
    public String toSource(int depth) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.makeIndent(depth));
        sb.append("break");
        if (this.breakLabel != null) {
            sb.append(" ");
            sb.append(this.breakLabel.toSource(0));
        }
        sb.append(";\n");
        return sb.toString();
    }

    @Override
    public void visit(NodeVisitor v) {
        if (v.visit(this) && this.breakLabel != null) {
            this.breakLabel.visit(v);
        }
    }
}

