/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.mozilla.javascript;

import org.watermedia.shaded.mozilla.javascript.Arguments;
import org.watermedia.shaded.mozilla.javascript.Context;
import org.watermedia.shaded.mozilla.javascript.IdFunctionObject;
import org.watermedia.shaded.mozilla.javascript.IdScriptableObject;
import org.watermedia.shaded.mozilla.javascript.InterpretedFunction;
import org.watermedia.shaded.mozilla.javascript.NativeFunction;
import org.watermedia.shaded.mozilla.javascript.ScriptRuntime;
import org.watermedia.shaded.mozilla.javascript.Scriptable;
import org.watermedia.shaded.mozilla.javascript.Undefined;

public final class NativeCall
extends IdScriptableObject {
    private static final long serialVersionUID = -7471457301304454454L;
    private static final Object CALL_TAG = "Call";
    private static final int Id_constructor = 1;
    private static final int MAX_PROTOTYPE_ID = 1;
    NativeFunction function;
    Object[] originalArgs;
    boolean isStrict;
    private Arguments arguments;
    boolean isArrow;
    private Scriptable homeObject;
    transient NativeCall parentActivationCall;

    static void init(Scriptable scope, boolean sealed) {
        NativeCall obj = new NativeCall();
        obj.exportAsJSClass(1, scope, sealed);
    }

    NativeCall() {
    }

    NativeCall(NativeFunction function, Context cx, Scriptable scope, Object[] args, boolean isArrow, boolean isStrict, boolean argsHasRest, Scriptable homeObject) {
        this.function = function;
        this.homeObject = homeObject;
        this.isArrow = isArrow;
        this.setParentScope(scope);
        this.originalArgs = args == null ? ScriptRuntime.emptyArgs : args;
        this.isStrict = isStrict;
        int paramAndVarCount = function.getParamAndVarCount();
        int paramCount = function.getParamCount();
        if (paramAndVarCount != 0) {
            if (argsHasRest) {
                Object[] vals;
                if (args.length >= paramCount) {
                    vals = new Object[args.length - paramCount];
                    System.arraycopy(args, paramCount, vals, 0, args.length - paramCount);
                } else {
                    vals = ScriptRuntime.emptyArgs;
                }
                for (int i = 0; i < paramCount; ++i) {
                    String name = function.getParamOrVarName(i);
                    Object val = i < args.length ? args[i] : Undefined.instance;
                    this.defineProperty(name, val, 4);
                }
                this.defineProperty(function.getParamOrVarName(paramCount), (Object)cx.newArray(scope, vals), 4);
            } else {
                for (int i = 0; i < paramCount; ++i) {
                    String name = function.getParamOrVarName(i);
                    Object val = i < args.length ? args[i] : Undefined.instance;
                    this.defineProperty(name, val, 4);
                }
            }
        }
        if (!super.has("arguments", (Scriptable)this) && !isArrow) {
            this.arguments = new Arguments(this);
            this.defineProperty("arguments", (Object)this.arguments, 4);
        }
        if (paramAndVarCount != 0) {
            for (int i = paramCount; i < paramAndVarCount; ++i) {
                String name = function.getParamOrVarName(i);
                if (super.has(name, (Scriptable)this)) continue;
                if (function.getParamOrVarConst(i)) {
                    this.defineProperty(name, Undefined.instance, 13);
                    continue;
                }
                if (function instanceof InterpretedFunction && !((InterpretedFunction)function).hasFunctionNamed(name)) continue;
                this.defineProperty(name, Undefined.instance, 4);
            }
        }
    }

    @Override
    public String getClassName() {
        return "Call";
    }

    @Override
    protected int findPrototypeId(String s) {
        return s.equals("constructor") ? 1 : 0;
    }

    @Override
    protected void initPrototypeId(int id2) {
        if (id2 != 1) {
            throw new IllegalArgumentException(String.valueOf(id2));
        }
        int arity = 1;
        String s = "constructor";
        this.initPrototypeMethod(CALL_TAG, id2, s, arity);
    }

    @Override
    public Object execIdCall(IdFunctionObject f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!f.hasTag(CALL_TAG)) {
            return super.execIdCall(f, cx, scope, thisObj, args);
        }
        int id2 = f.methodId();
        if (id2 == 1) {
            if (thisObj != null) {
                throw Context.reportRuntimeErrorById("msg.only.from.new", "Call");
            }
            ScriptRuntime.checkDeprecated(cx, "Call");
            NativeCall result = new NativeCall();
            result.setPrototype(NativeCall.getObjectPrototype(scope));
            return result;
        }
        throw new IllegalArgumentException(String.valueOf(id2));
    }

    public void defineAttributesForArguments() {
        if (this.arguments != null) {
            this.arguments.defineAttributesForStrictMode();
        }
    }

    public Scriptable getHomeObject() {
        return this.homeObject;
    }
}

