/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.jsoup.nodes;

import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.watermedia.shaded.jsoup.Connection;
import org.watermedia.shaded.jsoup.Jsoup;
import org.watermedia.shaded.jsoup.helper.HttpConnection;
import org.watermedia.shaded.jsoup.helper.Validate;
import org.watermedia.shaded.jsoup.internal.SharedConstants;
import org.watermedia.shaded.jsoup.internal.StringUtil;
import org.watermedia.shaded.jsoup.nodes.Attributes;
import org.watermedia.shaded.jsoup.nodes.Document;
import org.watermedia.shaded.jsoup.nodes.Element;
import org.watermedia.shaded.jsoup.nodes.Node;
import org.watermedia.shaded.jsoup.parser.Tag;
import org.watermedia.shaded.jsoup.select.Elements;
import org.watermedia.shaded.jsoup.select.Evaluator;
import org.watermedia.shaded.jsoup.select.Selector;

public class FormElement
extends Element {
    private final Elements linkedEls = new Elements();
    private static final Evaluator submittable = Selector.evaluatorOf(StringUtil.join(SharedConstants.FormSubmitTags, ", "));

    public FormElement(Tag tag, @Nullable String baseUri, @Nullable Attributes attributes) {
        super(tag, baseUri, attributes);
    }

    public Elements elements() {
        Elements els = this.select(submittable);
        for (Element linkedEl : this.linkedEls) {
            if (linkedEl.ownerDocument() == null || els.contains(linkedEl)) continue;
            els.add(linkedEl);
        }
        return els;
    }

    public FormElement addElement(Element element) {
        this.linkedEls.add(element);
        return this;
    }

    @Override
    protected void removeChild(Node out) {
        super.removeChild(out);
        this.linkedEls.remove(out);
    }

    public Connection submit() {
        String action = this.hasAttr("action") ? this.absUrl("action") : this.baseUri();
        Validate.notEmpty(action, "Could not determine a form action URL for submit. Ensure you set a base URI when parsing.");
        Connection.Method method = this.attr("method").equalsIgnoreCase("POST") ? Connection.Method.POST : Connection.Method.GET;
        Document owner = this.ownerDocument();
        Connection connection = owner != null ? owner.connection().newRequest() : Jsoup.newSession();
        return connection.url(action).data(this.formData()).method(method);
    }

    public List<Connection.KeyVal> formData() {
        ArrayList<Connection.KeyVal> data = new ArrayList<Connection.KeyVal>();
        Elements formEls = this.elements();
        for (Element el2 : formEls) {
            String type;
            String name;
            if (!el2.tag().isFormSubmittable() || el2.hasAttr("disabled") || (name = el2.attr("name")).length() == 0 || (type = el2.attr("type")).equalsIgnoreCase("button") || type.equalsIgnoreCase("image")) continue;
            if (el2.nameIs("select")) {
                Element option;
                Elements options = el2.select("option[selected]");
                boolean set = false;
                for (Element option2 : options) {
                    data.add(HttpConnection.KeyVal.create(name, option2.val()));
                    set = true;
                }
                if (set || (option = el2.selectFirst("option")) == null) continue;
                data.add(HttpConnection.KeyVal.create(name, option.val()));
                continue;
            }
            if ("checkbox".equalsIgnoreCase(type) || "radio".equalsIgnoreCase(type)) {
                if (!el2.hasAttr("checked")) continue;
                String val = el2.val().length() > 0 ? el2.val() : "on";
                data.add(HttpConnection.KeyVal.create(name, val));
                continue;
            }
            data.add(HttpConnection.KeyVal.create(name, el2.val()));
        }
        return data;
    }

    @Override
    public FormElement clone() {
        return (FormElement)super.clone();
    }
}

