/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.videolan4j.player.embedded.fullscreen.exclusivemode;

import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import org.watermedia.videolan4j.player.embedded.fullscreen.FullScreenStrategy;

public class ExclusiveModeFullScreenStrategy
implements FullScreenStrategy {
    private final Window window;

    public ExclusiveModeFullScreenStrategy(Window window) {
        if (window == null) {
            throw new IllegalArgumentException("Window must not be null");
        }
        this.window = window;
    }

    @Override
    public void enterFullScreenMode() {
        GraphicsDevice graphicsDevice = this.getScreenDevice();
        if (graphicsDevice.isFullScreenSupported()) {
            this.onBeforeEnterFullScreenMode();
            graphicsDevice.setFullScreenWindow(this.window);
            DisplayMode displayMode = this.getDisplayMode(graphicsDevice.getDisplayModes());
            if (displayMode != null) {
                graphicsDevice.setDisplayMode(displayMode);
            }
        }
    }

    @Override
    public void exitFullScreenMode() {
        this.getScreenDevice().setFullScreenWindow(null);
        this.onAfterExitFullScreenMode();
    }

    @Override
    public boolean isFullScreenMode() {
        return this.getScreenDevice().getFullScreenWindow() != null;
    }

    protected GraphicsDevice getScreenDevice() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
    }

    protected DisplayMode getDisplayMode(DisplayMode[] displayModes) {
        return null;
    }

    protected void onBeforeEnterFullScreenMode() {
    }

    protected void onAfterExitFullScreenMode() {
    }
}

