/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.videolan4j.player.base;

import org.watermedia.videolan4j.media.MediaRef;
import org.watermedia.videolan4j.player.base.MediaPlayer;
import org.watermedia.videolan4j.player.base.MediaPlayerEventAdapter;
import org.watermedia.videolan4j.player.base.events.MediaPlayerEventFactory;

final class MediaPlayerReadyEventHandler
extends MediaPlayerEventAdapter {
    private volatile boolean fired;

    MediaPlayerReadyEventHandler() {
    }

    @Override
    public void mediaChanged(MediaPlayer mediaPlayer, MediaRef media) {
        this.fired = false;
    }

    @Override
    public void positionChanged(MediaPlayer mediaPlayer, float newPosition) {
        if (!this.fired && newPosition > 0.0f) {
            this.fired = true;
            mediaPlayer.events().raiseEvent(MediaPlayerEventFactory.createMediaPlayerReadyEvent(mediaPlayer));
        }
    }

    @Override
    public void stopped(MediaPlayer mediaPlayer) {
        this.fired = false;
    }

    @Override
    public void finished(MediaPlayer mediaPlayer) {
        this.fired = false;
    }
}

