/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.api.network;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.watermedia.WaterMedia;
import org.watermedia.api.WaterMediaAPI;
import org.watermedia.api.network.patchs.AbstractPatch;
import org.watermedia.api.network.patchs.DiskPatch;
import org.watermedia.api.network.patchs.DrivePatch;
import org.watermedia.api.network.patchs.DropboxPatch;
import org.watermedia.api.network.patchs.KickPatch;
import org.watermedia.api.network.patchs.LightshotPatch;
import org.watermedia.api.network.patchs.MediaFirePatch;
import org.watermedia.api.network.patchs.OnedrivePatch;
import org.watermedia.api.network.patchs.PornHubPatch;
import org.watermedia.api.network.patchs.StreamablePatch;
import org.watermedia.api.network.patchs.TwitchPatch;
import org.watermedia.api.network.patchs.TwitterPatch;
import org.watermedia.loaders.ILoader;

public class NetworkAPI
extends WaterMediaAPI {
    public static final Marker IT = MarkerManager.getMarker((String)"NetworkAPI");
    private static final List<AbstractPatch> FIXERS = new ArrayList<AbstractPatch>();
    private static final Map<URI, AbstractPatch.Result> CACHE = new ConcurrentHashMap<URI, AbstractPatch.Result>(){
        private final HashMap<AbstractPatch.Result, Long> EXPIRES_IN = new HashMap();

        @Override
        public AbstractPatch.Result get(Object key) {
            AbstractPatch.Result patch = (AbstractPatch.Result)super.get(key);
            if (patch != null) {
                long expires = this.EXPIRES_IN.get(patch);
                if (System.currentTimeMillis() > expires) {
                    this.EXPIRES_IN.remove(patch);
                    this.remove(key);
                    WaterMedia.LOGGER.debug("Cache patch for '{}' has expired", key);
                    return null;
                }
                return patch;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AbstractPatch.Result put(URI key, AbstractPatch.Result value) {
            try {
                AbstractPatch.Result result = super.put(key, value);
                return result;
            }
            finally {
                this.EXPIRES_IN.put(value, System.currentTimeMillis() + 10000L);
            }
        }
    };

    @Deprecated
    public static AbstractPatch.Result patch(String strURI) {
        try {
            URI uri = NetworkAPI.parseURI(strURI);
            return NetworkAPI.patch(uri);
        }
        catch (Exception e) {
            WaterMedia.LOGGER.error(IT, "Exception occurred fixing URL", (Throwable)e);
            return null;
        }
    }

    public static AbstractPatch.Result patch(URI uri) {
        try {
            for (AbstractPatch fixer : FIXERS) {
                if (!fixer.isValid(uri)) continue;
                AbstractPatch.Result r = CACHE.get(uri);
                if (r != null) {
                    return r;
                }
                r = fixer.patch(uri, null);
                CACHE.put(uri, r);
                return r;
            }
            return new AbstractPatch.Result(uri, false, false);
        }
        catch (Exception e) {
            WaterMedia.LOGGER.error(IT, "Exception occurred fixing URL", (Throwable)e);
            return null;
        }
    }

    public static URI parseURI(String s) {
        File f = new File(s);
        if (!f.isDirectory() && f.exists()) {
            return new File(s).toURI();
        }
        try {
            return new URI(s);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String[] getPatchPlatforms() {
        String[] result = new String[FIXERS.size()];
        for (int i = 0; i < FIXERS.size(); ++i) {
            AbstractPatch fixer = FIXERS.get(i);
            result[i] = fixer.platform();
        }
        return result;
    }

    public static Map<String, String> parseQuery(String query) {
        String[] params;
        HashMap<String, String> queryParams = new HashMap<String, String>();
        for (String param : params = query.split("&")) {
            String[] keyValue = param.split("=");
            if (keyValue.length != 2) continue;
            String key = keyValue[0];
            String value = keyValue[1];
            queryParams.put(key, value);
        }
        return queryParams;
    }

    public static void registerPatch(AbstractPatch patch) {
        if (patch != null && !FIXERS.contains(patch)) {
            FIXERS.add(patch);
        }
    }

    public static void unregisterPatch(AbstractPatch patch) {
        if (patch != null) {
            FIXERS.remove(patch);
        }
    }

    @Override
    public WaterMediaAPI.Priority priority() {
        return WaterMediaAPI.Priority.NORMAL;
    }

    @Override
    public boolean prepare(ILoader bootCore) throws Exception {
        return FIXERS.isEmpty();
    }

    @Override
    public void start(ILoader bootCore) throws Exception {
        NetworkAPI.registerPatch(new DiskPatch());
        NetworkAPI.registerPatch(new DrivePatch());
        NetworkAPI.registerPatch(new DropboxPatch());
        NetworkAPI.registerPatch(new KickPatch());
        NetworkAPI.registerPatch(new LightshotPatch());
        NetworkAPI.registerPatch(new MediaFirePatch());
        NetworkAPI.registerPatch(new OnedrivePatch());
        NetworkAPI.registerPatch(new PornHubPatch());
        NetworkAPI.registerPatch(new StreamablePatch());
        NetworkAPI.registerPatch(new TwitchPatch());
        NetworkAPI.registerPatch(new TwitterPatch());
    }

    @Override
    public void release() {
        FIXERS.clear();
        CACHE.clear();
    }
}

