/*
 * Decompiled with CFR 0.152.
 */
package com.wateringcan;

import com.denfop.IUCore;
import com.denfop.api.crop.CropNetwork;
import com.denfop.blockentity.crop.TileEntityCrop;
import com.denfop.items.ItemFluidContainer;
import com.denfop.tabs.IItemTab;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class ItemWateringCan
extends ItemFluidContainer
implements IItemTab {
    private final int radius;

    public ItemWateringCan(int radius, int size) {
        super(10000 * size, 1);
        this.radius = radius;
    }

    public CreativeModeTab getItemCategory() {
        return IUCore.ItemTab;
    }

    public void fillItemCategory(CreativeModeTab p_41391_, NonNullList<ItemStack> p_41392_) {
        if (this.allowedIn(p_41391_)) {
            p_41392_.add((Object)new ItemStack((ItemLike)this));
            p_41392_.add((Object)this.getItemStack((Fluid)Fluids.f_76193_));
        }
    }

    public boolean contains(BlockPos vec, AABB searchArea) {
        if ((double)vec.m_123341_() > searchArea.f_82288_ && (double)vec.m_123341_() < searchArea.f_82291_) {
            if ((double)vec.m_123342_() > searchArea.f_82289_ && (double)vec.m_123342_() < searchArea.f_82292_) {
                return (double)vec.m_123343_() > searchArea.f_82290_ && (double)vec.m_123343_() < searchArea.f_82293_;
            }
            return false;
        }
        return false;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext p_41427_) {
        IFluidHandlerItem handler;
        FluidStack fluidStack;
        Level level = p_41427_.m_43725_();
        BlockPos pos = p_41427_.m_8083_();
        if (!level.f_46443_ && p_41427_.m_43723_().m_6144_() && !(fluidStack = (handler = (IFluidHandlerItem)FluidUtil.getFluidHandler((ItemStack)stack).orElse(null)).getFluidInTank(0)).isEmpty()) {
            AABB searchArea;
            AABB aabb = searchArea = new AABB(pos.m_7918_(-this.radius, -this.radius, -this.radius), pos.m_7918_(this.radius + 1, this.radius + 1, this.radius + 1));
            int j2 = Mth.m_14107_((double)((aabb.f_82288_ - 2.0) / 16.0));
            int k2 = Mth.m_14165_((double)((aabb.f_82291_ + 2.0) / 16.0));
            int l2 = Mth.m_14107_((double)((aabb.f_82290_ - 2.0) / 16.0));
            int i3 = Mth.m_14165_((double)((aabb.f_82293_ + 2.0) / 16.0));
            ArrayList<ChunkPos> chunks = new ArrayList<ChunkPos>();
            for (int j3 = j2; j3 < k2; ++j3) {
                for (int k3 = l2; k3 < i3; ++k3) {
                    LevelChunk levelChunk = level.m_6325_(j3, k3);
                    if (chunks.contains(levelChunk.m_7697_())) continue;
                    chunks.add(levelChunk.m_7697_());
                }
            }
            ArrayList<List> list = new ArrayList<List>();
            for (ChunkPos chunkPos : chunks) {
                list.add(CropNetwork.instance.getCropsFromChunk(level, chunkPos));
            }
            for (List list2 : list) {
                for (TileEntityCrop crop : list2) {
                    if (!this.contains(crop.getPos(), searchArea) || crop.getCrop() == null || crop.getCrop().getTick() >= crop.getCrop().getMaxTick() || crop.getCrop().getId() == 3 || handler.drain(100, IFluidHandler.FluidAction.EXECUTE).isEmpty()) continue;
                    crop.getCrop().addTick((int)((double)crop.getCrop().getMaxTick() * 0.2));
                    crop.setActive(crop.getCrop().getName().toLowerCase() + "_" + crop.getCrop().getStage());
                }
            }
        }
        return InteractionResult.PASS;
    }

    public boolean canfill(Fluid fluid) {
        return fluid == Fluids.f_76193_;
    }
}

