/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.dimension.DimensionType;

public class WorldHelper {
    private WorldHelper() {
    }

    public static Optional<BlockEntity> getBlockEntity(@Nullable BlockGetter level, BlockPos pos) {
        return WorldHelper.getBlockEntity(level, pos, BlockEntity.class);
    }

    public static Optional<BlockEntity> getLoadedBlockEntity(@Nullable Level level, BlockPos pos) {
        if (level != null && level.m_46749_(pos)) {
            return Optional.ofNullable(level.m_7702_(pos));
        }
        return Optional.empty();
    }

    public static <T> Optional<T> getLoadedBlockEntity(@Nullable Level level, BlockPos pos, Class<T> teClass) {
        if (level != null && level.m_46749_(pos)) {
            return WorldHelper.getBlockEntity((BlockGetter)level, pos, teClass);
        }
        return Optional.empty();
    }

    public static <T> Optional<T> getBlockEntity(@Nullable BlockGetter level, BlockPos pos, Class<T> teClass) {
        if (level == null) {
            return Optional.empty();
        }
        BlockEntity te = level.m_7702_(pos);
        if (teClass.isInstance(te)) {
            return Optional.of(teClass.cast(te));
        }
        return Optional.empty();
    }

    public static void notifyBlockUpdate(BlockEntity tile) {
        Level world = tile.m_58904_();
        if (world == null) {
            return;
        }
        world.m_7260_(tile.m_58899_(), tile.m_58900_(), tile.m_58900_(), 3);
    }

    public static <T> List<T> getBlockEntitiesInRange(Level level, BlockPos origin, int range, Class<T> beClass) {
        ArrayList<T> out = new ArrayList<T>();
        int minX = origin.m_123341_() - range;
        int maxX = origin.m_123341_() + range;
        int minZ = origin.m_123343_() - range;
        int maxZ = origin.m_123343_() + range;
        DimensionType dim = level.m_6042_();
        int minY = Math.max(origin.m_123342_() - range, dim.f_156647_());
        int maxY = Math.min(origin.m_123342_() + range, dim.f_156647_() + dim.f_156648_() - 1);
        int minCx = minX >> 4;
        int maxCx = maxX >> 4;
        int minCz = minZ >> 4;
        int maxCz = maxZ >> 4;
        long maxDist = (long)range * (long)range;
        for (int cz = minCz; cz <= maxCz; ++cz) {
            for (int cx = minCx; cx <= maxCx; ++cx) {
                LevelChunk chunk = level.m_7726_().m_7131_(cx, cz);
                if (chunk == null) continue;
                for (BlockEntity be : chunk.m_62954_().values()) {
                    long dz;
                    long dx;
                    long beDist;
                    BlockPos pos;
                    int y;
                    if (be == null || be.m_58901_() || !beClass.isInstance(be) || (y = (pos = be.m_58899_()).m_123342_()) < minY || y > maxY || (beDist = (dx = (long)pos.m_123341_() - (long)origin.m_123341_()) * dx + (dz = (long)pos.m_123343_() - (long)origin.m_123343_()) * dz) > maxDist) continue;
                    out.add(beClass.cast(be));
                }
            }
        }
        return out;
    }
}

