/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox;

import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.ServerStorageSoundHandler;

public class SoundFinishedNotificationMessage {
    private final UUID storageUuid;

    public SoundFinishedNotificationMessage(UUID storageUuid) {
        this.storageUuid = storageUuid;
    }

    public static void encode(SoundFinishedNotificationMessage msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130077_(msg.storageUuid);
    }

    public static SoundFinishedNotificationMessage decode(FriendlyByteBuf packetBuffer) {
        return new SoundFinishedNotificationMessage(packetBuffer.m_130259_());
    }

    public static void onMessage(SoundFinishedNotificationMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> SoundFinishedNotificationMessage.handleMessage(context.getSender(), msg));
        context.setPacketHandled(true);
    }

    private static void handleMessage(@Nullable ServerPlayer sender, SoundFinishedNotificationMessage msg) {
        if (sender == null) {
            return;
        }
        ServerStorageSoundHandler.onSoundFinished((ServerLevel)sender.m_9236_(), msg.storageUuid);
    }
}

