/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.network;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.common.IItemActionPayloadHandler;
import net.p3pp3rf1y.sophisticatedcore.common.ItemActionHandlerRegistry;
import net.p3pp3rf1y.sophisticatedcore.controller.IControllableStorage;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.network.PacketHandler;
import net.p3pp3rf1y.sophisticatedcore.network.SyncItemTransfersMessage;
import net.p3pp3rf1y.sophisticatedcore.util.RandHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;

public record RestockItemsMessage(ItemStack filter, int minSlot, int maxSlot, boolean fillEmpty, List<BlockPos> storagePositions, Map<ResourceLocation, Object> extras) {
    public static void encode(RestockItemsMessage msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130055_(msg.filter);
        packetBuffer.writeInt(msg.minSlot);
        packetBuffer.writeInt(msg.maxSlot);
        packetBuffer.writeBoolean(msg.fillEmpty);
        packetBuffer.m_236828_(msg.storagePositions, FriendlyByteBuf::m_130064_);
        RestockItemsMessage.encodeExtras(msg.extras, packetBuffer);
    }

    private static void encodeExtras(Map<ResourceLocation, Object> extras, FriendlyByteBuf packetBuffer) {
        packetBuffer.writeInt(extras.size());
        for (Map.Entry<ResourceLocation, Object> e : extras.entrySet()) {
            ResourceLocation id = e.getKey();
            ItemActionHandlerRegistry.get(id).ifPresent(h -> {
                packetBuffer.m_130085_(id);
                RestockItemsMessage.encodeWith(h, packetBuffer, e.getValue());
            });
        }
    }

    private static <T> void encodeWith(IItemActionPayloadHandler<T> handler, FriendlyByteBuf packetBuffer, Object v) {
        handler.encode(packetBuffer, v);
    }

    public static RestockItemsMessage decode(FriendlyByteBuf packetBuffer) {
        return new RestockItemsMessage(packetBuffer.m_130267_(), packetBuffer.readInt(), packetBuffer.readInt(), packetBuffer.readBoolean(), packetBuffer.m_236845_(FriendlyByteBuf::m_130135_), RestockItemsMessage.decodeExtras(packetBuffer));
    }

    private static Map<ResourceLocation, Object> decodeExtras(FriendlyByteBuf packetBuffer) {
        int size = packetBuffer.readInt();
        LinkedHashMap<ResourceLocation, Object> extras = new LinkedHashMap<ResourceLocation, Object>(size);
        for (int i = 0; i < size; ++i) {
            ResourceLocation id = packetBuffer.m_130281_();
            ItemActionHandlerRegistry.get(id).ifPresent(h -> extras.put(id, h.decode(packetBuffer)));
        }
        return extras;
    }

    static void onMessage(RestockItemsMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> RestockItemsMessage.handleMessage(msg, context));
        context.setPacketHandled(true);
    }

    public static void handleMessage(RestockItemsMessage msg, NetworkEvent.Context context) {
        MutableComponent message;
        ServerPlayer player = context.getSender();
        Level level = player.m_9236_();
        TreeMap<Vec3, InventoryHandler> restockHandlers = new TreeMap<Vec3, InventoryHandler>(Comparator.comparingDouble(arg_0 -> ((Player)player).m_20238_(arg_0)).thenComparingDouble(Vec3::m_7096_).thenComparingDouble(Vec3::m_7098_).thenComparingDouble(Vec3::m_7094_));
        msg.storagePositions().stream().filter(arg_0 -> RestockItemsMessage.lambda$handleMessage$3((Player)player, level, arg_0)).map(pos -> WorldHelper.getBlockEntity((BlockGetter)level, pos, IControllableStorage.class)).filter(Optional::isPresent).map(Optional::get).forEach(s -> restockHandlers.put(s.getStorageBlockPos().m_252807_(), s.getStorageWrapper().getInventoryHandler()));
        msg.extras().forEach((arg_0, arg_1) -> RestockItemsMessage.lambda$handleMessage$7(restockHandlers, (Player)player, arg_0, arg_1));
        ItemStackKey filterStackKey = ItemStackKey.of(msg.filter());
        HashMap<Vec3, ItemStack> transferredItems = new HashMap<Vec3, ItemStack>();
        HashSet<Integer> restockedPlayerSlots = new HashSet<Integer>();
        for (int playerInventorySlot = msg.minSlot(); playerInventorySlot < msg.maxSlot(); ++playerInventorySlot) {
            ItemStack playerInventoryStack = player.m_150109_().m_8020_(playerInventorySlot);
            if (msg.fillEmpty() && !msg.filter().m_41619_()) {
                if (!playerInventoryStack.m_41619_() && !ItemStack.m_150942_((ItemStack)playerInventoryStack, (ItemStack)msg.filter())) continue;
                RestockItemsMessage.restockSlot(restockHandlers, filterStackKey, playerInventoryStack, transferredItems, restockedPlayerSlots, (Player)player, playerInventorySlot);
                continue;
            }
            if (playerInventoryStack.m_41619_()) continue;
            RestockItemsMessage.restockSlot(restockHandlers, ItemStackKey.of(playerInventoryStack), playerInventoryStack, transferredItems, restockedPlayerSlots, (Player)player, playerInventorySlot);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = player;
            Vec3 playerPos = player.m_146892_().m_82520_(0.0, -0.1, 0.0);
            PacketHandler.INSTANCE.sendToClient(serverPlayer, new SyncItemTransfersMessage(transferredItems, playerPos, false));
            PacketHandler.INSTANCE.sendToAllTracking(new SyncItemTransfersMessage(transferredItems, playerPos, false), (Entity)serverPlayer);
        }
        if (msg.maxSlot() - msg.minSlot() == 1) {
            if (transferredItems.isEmpty()) {
                ItemStack item = msg.fillEmpty() ? filterStackKey.getStack() : player.m_150109_().m_8020_(msg.minSlot());
                message = TranslationHelper.INSTANCE.translStatusMessage("cannot_restock_item", Component.m_237113_((String)item.m_41786_().getString()).m_130940_(ChatFormatting.RED));
                player.m_6330_((SoundEvent)SoundEvents.f_12209_.m_203334_(), SoundSource.PLAYERS, 1.0f, 0.7f + RandHelper.getRandomMinusOneToOne(level.f_46441_) * 0.1f);
            } else {
                message = TranslationHelper.INSTANCE.translStatusMessage("restocked_item", Component.m_237113_((String)((ItemStack)transferredItems.values().iterator().next()).m_41786_().getString()).m_130940_(ChatFormatting.DARK_GREEN));
            }
        } else if (transferredItems.isEmpty()) {
            message = TranslationHelper.INSTANCE.translStatusMessage("cannot_restock_items", new Object[0]);
            player.m_6330_((SoundEvent)SoundEvents.f_12209_.m_203334_(), SoundSource.PLAYERS, 1.0f, 0.7f + RandHelper.getRandomMinusOneToOne(level.f_46441_) * 0.1f);
        } else {
            message = TranslationHelper.INSTANCE.translStatusMessage("restocked_items", Component.m_237113_((String)String.valueOf(restockedPlayerSlots.size())).m_130940_(ChatFormatting.DARK_GREEN));
        }
        player.m_5661_((Component)message, true);
    }

    private static void restockSlot(Map<Vec3, InventoryHandler> restockHandlers, ItemStackKey stackKey, ItemStack playerInventoryStack, Map<Vec3, ItemStack> restocked, Set<Integer> restockedPlayerSlots, Player player, int playerInventorySlot) {
        for (Map.Entry<Vec3, InventoryHandler> entry : restockHandlers.entrySet()) {
            Vec3 pos = entry.getKey();
            InventoryHandler handler = entry.getValue();
            int matchingStackSlot = handler.getSlotTracker().getFirstMatchingSlot(stackKey);
            while (matchingStackSlot != -1 && playerInventoryStack.m_41613_() < playerInventoryStack.m_41741_()) {
                ItemStack extracted = handler.extractItem(matchingStackSlot, playerInventoryStack.m_41741_() - playerInventoryStack.m_41613_(), false);
                if (!extracted.m_41619_()) {
                    restocked.put(pos, extracted.m_255036_(restocked.getOrDefault(pos, ItemStack.f_41583_).m_41613_() + extracted.m_41613_()));
                    if (playerInventoryStack.m_41619_()) {
                        playerInventoryStack = extracted.m_41777_();
                    } else {
                        playerInventoryStack.m_41769_(extracted.m_41613_());
                    }
                    player.m_150109_().m_6836_(playerInventorySlot, playerInventoryStack);
                    restockedPlayerSlots.add(playerInventorySlot);
                }
                matchingStackSlot = handler.getSlotTracker().getFirstMatchingSlot(stackKey);
            }
        }
    }

    private static <T> Map<Vec3, InventoryHandler> getTargetInventories(IItemActionPayloadHandler<T> handler, Player player, Object extraData) {
        return handler.getTargetInventories(player, extraData);
    }

    private static /* synthetic */ void lambda$handleMessage$7(Map restockHandlers, Player player, ResourceLocation id, Object extraData) {
        ItemActionHandlerRegistry.get(id).ifPresent(handler -> restockHandlers.putAll(RestockItemsMessage.getTargetInventories(handler, player, extraData)));
    }

    private static /* synthetic */ boolean lambda$handleMessage$3(Player player, Level level, BlockPos pos) {
        return player.m_142265_(level, pos);
    }
}

