/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.network;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.common.IItemActionPayloadHandler;
import net.p3pp3rf1y.sophisticatedcore.common.ItemActionHandlerRegistry;
import net.p3pp3rf1y.sophisticatedcore.controller.ControllerBlockEntityBase;
import net.p3pp3rf1y.sophisticatedcore.controller.IControllableStorage;
import net.p3pp3rf1y.sophisticatedcore.inventory.ISlotTracker;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.network.PacketHandler;
import net.p3pp3rf1y.sophisticatedcore.network.SyncItemTransfersMessage;
import net.p3pp3rf1y.sophisticatedcore.util.RandHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;

public record DepositItemsMessage(int minSlot, int maxSlot, List<BlockPos> storagePositions, List<BlockPos> controllerPositions, Map<ResourceLocation, Object> extras, boolean onlyMatching) {
    public static void encode(DepositItemsMessage msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.writeInt(msg.minSlot);
        packetBuffer.writeInt(msg.maxSlot);
        packetBuffer.m_236828_(msg.storagePositions, FriendlyByteBuf::m_130064_);
        packetBuffer.m_236828_(msg.controllerPositions, FriendlyByteBuf::m_130064_);
        DepositItemsMessage.encodeExtras(msg.extras, packetBuffer);
        packetBuffer.writeBoolean(msg.onlyMatching);
    }

    private static void encodeExtras(Map<ResourceLocation, Object> extras, FriendlyByteBuf packetBuffer) {
        packetBuffer.writeInt(extras.size());
        for (Map.Entry<ResourceLocation, Object> e : extras.entrySet()) {
            ResourceLocation id = e.getKey();
            ItemActionHandlerRegistry.get(id).ifPresent(h -> {
                packetBuffer.m_130085_(id);
                DepositItemsMessage.encodeWith(h, packetBuffer, e.getValue());
            });
        }
    }

    private static <T> void encodeWith(IItemActionPayloadHandler<T> handler, FriendlyByteBuf packetBuffer, Object v) {
        handler.encode(packetBuffer, v);
    }

    public static DepositItemsMessage decode(FriendlyByteBuf packetBuffer) {
        return new DepositItemsMessage(packetBuffer.readInt(), packetBuffer.readInt(), packetBuffer.m_236845_(FriendlyByteBuf::m_130135_), packetBuffer.m_236845_(FriendlyByteBuf::m_130135_), DepositItemsMessage.decodeExtras(packetBuffer), packetBuffer.readBoolean());
    }

    private static Map<ResourceLocation, Object> decodeExtras(FriendlyByteBuf packetBuffer) {
        int size = packetBuffer.readInt();
        LinkedHashMap<ResourceLocation, Object> extras = new LinkedHashMap<ResourceLocation, Object>(size);
        for (int i = 0; i < size; ++i) {
            ResourceLocation id = packetBuffer.m_130281_();
            ItemActionHandlerRegistry.get(id).ifPresent(h -> extras.put(id, h.decode(packetBuffer)));
        }
        return extras;
    }

    static void onMessage(DepositItemsMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> DepositItemsMessage.handleMessage(msg, context));
        context.setPacketHandled(true);
    }

    public static void handleMessage(DepositItemsMessage msg, NetworkEvent.Context context) {
        MutableComponent message;
        ServerPlayer player = context.getSender();
        Level level = player.m_9236_();
        TreeMap<Vec3, IDepositHandler> depositHandlers = new TreeMap<Vec3, IDepositHandler>(Comparator.comparingDouble(arg_0 -> ((Player)player).m_20238_(arg_0)).thenComparingDouble(Vec3::m_7096_).thenComparingDouble(Vec3::m_7098_).thenComparingDouble(Vec3::m_7094_));
        HashSet<BlockPos> controllerPositions = new HashSet<BlockPos>(msg.controllerPositions());
        msg.storagePositions().stream().filter(arg_0 -> DepositItemsMessage.lambda$handleMessage$3((Player)player, level, arg_0)).map(pos -> WorldHelper.getBlockEntity((BlockGetter)level, pos, IControllableStorage.class)).filter(Optional::isPresent).map(Optional::get).forEach(s -> s.getControllerPos().ifPresentOrElse(controllerPositions::add, () -> depositHandlers.put(s.getStorageBlockPos().m_252807_(), new StorageDepositHandler(s.getStorageWrapper().getInventoryHandler()))));
        controllerPositions.stream().filter(arg_0 -> DepositItemsMessage.lambda$handleMessage$7((Player)player, level, arg_0)).map(arg_0 -> DepositItemsMessage.lambda$handleMessage$8((Player)player, arg_0)).filter(Optional::isPresent).map(Optional::get).forEach(c -> depositHandlers.put(c.m_58899_().m_252807_(), new ControllerDepositHandler((ControllerBlockEntityBase)c)));
        msg.extras().forEach((arg_0, arg_1) -> DepositItemsMessage.lambda$handleMessage$12((Player)player, depositHandlers, arg_0, arg_1));
        HashMap<Vec3, ItemStack> inserted = new HashMap<Vec3, ItemStack>();
        HashSet<Integer> depositedFromSlots = new HashSet<Integer>();
        DepositItemsMessage.depositSlotsToHandlers(msg, (Player)player, depositHandlers, inserted, depositedFromSlots, true);
        if (!msg.onlyMatching()) {
            DepositItemsMessage.depositSlotsToHandlers(msg, (Player)player, depositHandlers, inserted, depositedFromSlots, false);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = player;
            Vec3 playerPos = player.m_146892_().m_82520_(0.0, -0.1, 0.0);
            PacketHandler.INSTANCE.sendToClient(serverPlayer, new SyncItemTransfersMessage(inserted, playerPos, true));
            PacketHandler.INSTANCE.sendToAllTracking(new SyncItemTransfersMessage(inserted, playerPos, true), (Entity)serverPlayer);
        }
        if (msg.maxSlot() - msg.minSlot() == 1) {
            if (inserted.isEmpty()) {
                message = TranslationHelper.INSTANCE.translStatusMessage("cannot_deposit_item", Component.m_237113_((String)player.m_150109_().m_8020_(msg.minSlot()).m_41786_().getString()).m_130940_(ChatFormatting.RED));
                player.m_6330_((SoundEvent)SoundEvents.f_12209_.m_203334_(), SoundSource.PLAYERS, 1.0f, 0.7f + RandHelper.getRandomMinusOneToOne(level.f_46441_) * 0.1f);
            } else {
                message = TranslationHelper.INSTANCE.translStatusMessage("deposited_item", Component.m_237113_((String)((ItemStack)inserted.values().iterator().next()).m_41786_().getString()).m_130940_(ChatFormatting.DARK_GREEN));
            }
        } else if (inserted.isEmpty()) {
            message = TranslationHelper.INSTANCE.translStatusMessage("cannot_deposit_items", new Object[0]);
            player.m_6330_((SoundEvent)SoundEvents.f_12209_.m_203334_(), SoundSource.PLAYERS, 1.0f, 0.7f + RandHelper.getRandomMinusOneToOne(level.f_46441_) * 0.1f);
        } else {
            message = TranslationHelper.INSTANCE.translStatusMessage("deposited_items", Component.m_237113_((String)String.valueOf(depositedFromSlots.size())).m_130940_(ChatFormatting.DARK_GREEN));
        }
        player.m_5661_((Component)message, true);
    }

    private static void depositSlotsToHandlers(DepositItemsMessage payload, Player player, Map<Vec3, IDepositHandler> depositHandlers, Map<Vec3, ItemStack> inserted, Set<Integer> depositedFromSlots, boolean checkPresent) {
        block0: for (int slot = payload.minSlot(); slot < payload.maxSlot(); ++slot) {
            ItemStack stack = player.m_150109_().m_8020_(slot);
            if (stack.m_41619_()) continue;
            ItemStackKey stackKey = ItemStackKey.of(stack);
            for (Map.Entry<Vec3, IDepositHandler> entry : depositHandlers.entrySet()) {
                ItemStack remaining;
                Vec3 pos = entry.getKey();
                IDepositHandler handler = entry.getValue();
                if (checkPresent && !handler.isPresent(stackKey) || (remaining = handler.deposit(stack)).m_41613_() >= stack.m_41613_()) continue;
                inserted.put(pos, stack.m_255036_(stack.m_41613_() - remaining.m_41613_()));
                player.m_150109_().m_6836_(slot, remaining);
                depositedFromSlots.add(slot);
                stack = remaining;
                if (!stack.m_41619_()) continue;
                continue block0;
            }
        }
    }

    private static <T> Map<Vec3, InventoryHandler> getTargetInventories(IItemActionPayloadHandler<T> handler, Player player, Object extraData) {
        return handler.getTargetInventories(player, extraData);
    }

    private static /* synthetic */ void lambda$handleMessage$12(Player player, Map depositHandlers, ResourceLocation id, Object extraData) {
        ItemActionHandlerRegistry.get(id).ifPresent(handler -> DepositItemsMessage.getTargetInventories(handler, player, extraData).forEach((pos, inventory) -> depositHandlers.put(pos, new StorageDepositHandler((InventoryHandler)inventory))));
    }

    private static /* synthetic */ Optional lambda$handleMessage$8(Player player, BlockPos pos) {
        return WorldHelper.getBlockEntity((BlockGetter)player.m_9236_(), pos, ControllerBlockEntityBase.class);
    }

    private static /* synthetic */ boolean lambda$handleMessage$7(Player player, Level level, BlockPos pos) {
        return player.m_142265_(level, pos);
    }

    private static /* synthetic */ boolean lambda$handleMessage$3(Player player, Level level, BlockPos pos) {
        return player.m_142265_(level, pos);
    }

    private static interface IDepositHandler {
        public boolean isPresent(ItemStackKey var1);

        public ItemStack deposit(ItemStack var1);
    }

    private static class StorageDepositHandler
    implements IDepositHandler {
        private final InventoryHandler inventoryHandler;

        public StorageDepositHandler(InventoryHandler inventoryHandler) {
            this.inventoryHandler = inventoryHandler;
        }

        @Override
        public boolean isPresent(ItemStackKey stackKey) {
            ISlotTracker slotTracker = this.inventoryHandler.getSlotTracker();
            return slotTracker.getPartialStacks().contains(stackKey) || slotTracker.getFullStacks().contains(stackKey) || slotTracker.getItems().contains(stackKey.getStack().m_41720_()) || slotTracker.hasStackMemorizedOrFiltered(stackKey.getStack());
        }

        @Override
        public ItemStack deposit(ItemStack stack) {
            return this.inventoryHandler.insertItem(stack, false);
        }
    }

    private static class ControllerDepositHandler
    implements IDepositHandler {
        private final ControllerBlockEntityBase controller;

        public ControllerDepositHandler(ControllerBlockEntityBase controller) {
            this.controller = controller;
        }

        @Override
        public boolean isPresent(ItemStackKey stackKey) {
            return this.controller.hasMatchingStackOrItem(stackKey);
        }

        @Override
        public ItemStack deposit(ItemStack stack) {
            return this.controller.insertItem(stack, false);
        }
    }
}

