/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.command;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackTemplates;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.command.BackpackItemArgumentType;
import net.p3pp3rf1y.sophisticatedbackpacks.command.BackpackTemplateArgumentType;
import net.p3pp3rf1y.sophisticatedbackpacks.command.BackpackUpgradeItemArgumentType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeHandler;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.RandHelper;

public class DynamicCommand {
    static final Cache<String, DynamicTemplate> DYNAMIC_CACHE = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();

    static ArgumentBuilder<CommandSourceStack, ?> register(CommandBuildContext commandBuildContext) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"dynamic").then(Commands.m_82127_((String)"begin").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"templateName", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"backpackItem", (ArgumentType)BackpackItemArgumentType.item(commandBuildContext)).executes(context -> DynamicCommand.beginNewDynamic((CommandSourceStack)context.getSource(), (String)context.getArgument("templateName", String.class), BackpackItemArgumentType.m_120963_((CommandContext)context, (String)"backpackItem"))))).then(Commands.m_82129_((String)"baseTemplateName", (ArgumentType)BackpackTemplateArgumentType.templateName()).executes(context -> DynamicCommand.beginBasedDynamic((CommandSourceStack)context.getSource(), (String)context.getArgument("templateName", String.class), BackpackTemplateArgumentType.getId((CommandContext<CommandSourceStack>)context, "baseTemplateName"))))))).then(Commands.m_82127_((String)"addItem").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"templateName", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"slot", (ArgumentType)IntegerArgumentType.integer()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"item", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)commandBuildContext)).executes(context -> DynamicCommand.addDynamic((CommandSourceStack)context.getSource(), (String)context.getArgument("templateName", String.class), IntegerArgumentType.getInteger((CommandContext)context, (String)"slot"), ItemArgument.m_120963_((CommandContext)context, (String)"item"), 1, false))).then(Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> DynamicCommand.addDynamic((CommandSourceStack)context.getSource(), (String)context.getArgument("templateName", String.class), IntegerArgumentType.getInteger((CommandContext)context, (String)"slot"), ItemArgument.m_120963_((CommandContext)context, (String)"item"), IntegerArgumentType.getInteger((CommandContext)context, (String)"count"), false)))))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"item", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)commandBuildContext)).executes(context -> DynamicCommand.addDynamic((CommandSourceStack)context.getSource(), (String)context.getArgument("templateName", String.class), -1, ItemArgument.m_120963_((CommandContext)context, (String)"item"), 1, false))).then(Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> DynamicCommand.addDynamic((CommandSourceStack)context.getSource(), (String)context.getArgument("templateName", String.class), -1, ItemArgument.m_120963_((CommandContext)context, (String)"item"), IntegerArgumentType.getInteger((CommandContext)context, (String)"count"), false))))))).then(Commands.m_82127_((String)"addUpgrade").then(Commands.m_82129_((String)"templateName", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"item", (ArgumentType)BackpackUpgradeItemArgumentType.item(commandBuildContext)).executes(context -> DynamicCommand.addDynamic((CommandSourceStack)context.getSource(), (String)context.getArgument("templateName", String.class), -1, ItemArgument.m_120963_((CommandContext)context, (String)"item"), 1, true)))))).then(Commands.m_82127_((String)"end").then(Commands.m_82129_((String)"templateName", (ArgumentType)StringArgumentType.word()).executes(context -> DynamicCommand.endDynamic((CommandSourceStack)context.getSource(), (String)context.getArgument("templateName", String.class)))));
    }

    private static int beginNewDynamic(CommandSourceStack source, String templateName, ItemInput backpackItem) throws CommandSyntaxException {
        if (DYNAMIC_CACHE.asMap().containsKey(templateName)) {
            source.m_81352_((Component)Component.m_237110_((String)"commands.sophisticatedbackpacks.dynamic.templateInUse", (Object[])new Object[]{templateName}));
            return 1;
        }
        ItemStack backpack = backpackItem.m_120980_(1, false);
        DYNAMIC_CACHE.put((Object)templateName, (Object)new DynamicTemplate(backpack, new ArrayList<ItemStack>(), new ArrayList<ItemStack>()));
        source.m_288197_(() -> Component.m_237110_((String)"commands.sophisticatedbackpacks.dynamic.begin.success", (Object[])new Object[]{templateName}), false);
        return 0;
    }

    private static int beginBasedDynamic(CommandSourceStack source, String templateName, ResourceLocation baseTemplateName) {
        if (DYNAMIC_CACHE.getIfPresent((Object)templateName) != null) {
            source.m_81352_((Component)Component.m_237110_((String)"commands.sophisticatedbackpacks.dynamic.templateInUse", (Object[])new Object[]{templateName}));
            return 1;
        }
        Optional<CompoundTag> templateData = BackpackTemplates.getBackpackTemplate(baseTemplateName);
        if (templateData.isEmpty()) {
            source.m_81352_((Component)Component.m_237110_((String)"commands.sophisticatedbackpacks.dynamic.begin.noBaseTemplate", (Object[])new Object[]{baseTemplateName.toString()}));
            return 1;
        }
        ItemStack backpack = new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(templateData.get().m_128461_("backpackItemRegistryName"))));
        BackpackWrapper wrapper = new BackpackWrapper(backpack);
        wrapper.setTemplate(baseTemplateName);
        wrapper.fillFromTemplate();
        DYNAMIC_CACHE.put((Object)templateName, (Object)new DynamicTemplate(backpack, new ArrayList<ItemStack>(), new ArrayList<ItemStack>()));
        source.m_288197_(() -> Component.m_237110_((String)"commands.sophisticatedbackpacks.dynamic.begin.success", (Object[])new Object[]{templateName}), false);
        return 0;
    }

    private static int addDynamic(CommandSourceStack source, String templateName, int slot, ItemInput item, int count, boolean upgrade) throws CommandSyntaxException {
        DynamicTemplate template = (DynamicTemplate)DYNAMIC_CACHE.getIfPresent((Object)templateName);
        if (template == null) {
            source.m_81352_((Component)Component.m_237110_((String)"commands.sophisticatedbackpacks.dynamic.templateNotInUse", (Object[])new Object[]{templateName}));
            return 1;
        }
        ItemStack stack = item.m_120980_(count, true);
        if (slot == -1) {
            if (upgrade) {
                template.itemsForUpgradeHandler.add(stack);
            } else {
                template.itemsForInventoryHandler.add(stack);
            }
        } else {
            UpgradeHandler inventory;
            BackpackWrapper wrapper = new BackpackWrapper(template.backpack);
            Object object = inventory = upgrade ? wrapper.getUpgradeHandler() : wrapper.getInventoryHandler();
            if (!inventory.getStackInSlot(slot).m_41619_()) {
                template.itemsForInventoryHandler.add(stack);
            } else {
                inventory.setStackInSlot(slot, stack);
                source.m_288197_(() -> Component.m_237110_((String)"commands.sophisticatedbackpacks.dynamic.add.success", (Object[])new Object[]{templateName, stack.m_41611_()}), false);
                return 0;
            }
        }
        source.m_288197_(() -> Component.m_237110_((String)"commands.sophisticatedbackpacks.dynamic.add.delayed", (Object[])new Object[]{templateName, stack.m_41611_()}), false);
        return 0;
    }

    private static int endDynamic(CommandSourceStack source, String templateName) {
        Optional backpackUuid;
        DynamicTemplate template = (DynamicTemplate)DYNAMIC_CACHE.getIfPresent((Object)templateName);
        if (template == null) {
            source.m_81352_((Component)Component.m_237110_((String)"commands.sophisticatedbackpacks.dynamic.templateNotInUse", (Object[])new Object[]{templateName}));
            return 1;
        }
        BackpackWrapper wrapper = new BackpackWrapper(template.backpack);
        ArrayList remainings = new ArrayList();
        remainings.addAll(InventoryHelper.insertIntoInventory(template.itemsForInventoryHandler, (IItemHandler)wrapper.getInventoryHandler(), (boolean)false));
        remainings.addAll(InventoryHelper.insertIntoInventory(template.itemsForUpgradeHandler, (IItemHandler)wrapper.getUpgradeHandler(), (boolean)false));
        if (!remainings.isEmpty()) {
            for (ItemStack remaining : remainings) {
                source.m_81352_((Component)Component.m_237110_((String)"commands.sophisticatedbackpacks.dynamic.end.addRemainingItemsFailed", (Object[])new Object[]{remaining.m_41613_(), remaining.m_41611_()}));
            }
        }
        if ((backpackUuid = wrapper.getContentsUuid()).isEmpty() || InventoryHelper.isEmpty((IItemHandler)wrapper.getInventoryHandler()) && InventoryHelper.isEmpty((IItemHandler)wrapper.getUpgradeHandler())) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.sophisticatedbackpacks.template.backpackempty"));
            return 3;
        }
        if (source.m_230897_()) {
            DynamicCommand.giveBackpackToPlayer(template.backpack(), source.m_230896_());
        } else if (source.m_81373_() != null) {
            DynamicCommand.dropBackpackToPosition(template.backpack(), source.m_81372_(), source.m_81373_().m_20182_());
        } else {
            DynamicCommand.dropBackpackToPosition(template.backpack(), source.m_81372_(), source.m_81371_());
        }
        DYNAMIC_CACHE.invalidate((Object)templateName);
        source.m_288197_(() -> Component.m_237110_((String)"commands.sophisticatedbackpacks.dynamic.end.success", (Object[])new Object[]{templateName}), false);
        return 0;
    }

    private static void giveBackpackToPlayer(ItemStack backpack, ServerPlayer p) {
        ItemEntity itemEntity;
        boolean flag = p.m_150109_().m_36054_(backpack);
        if (flag && backpack.m_41619_()) {
            backpack.m_41764_(1);
            itemEntity = p.m_36176_(backpack, false);
            if (itemEntity != null) {
                itemEntity.m_32065_();
            }
            p.m_9236_().m_6263_(null, p.m_20185_(), p.m_20186_(), p.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, (RandHelper.getRandomMinusOneToOne((RandomSource)p.m_217043_()) * 0.7f + 1.0f) * 2.0f);
            p.f_36095_.m_38946_();
        } else {
            ItemEntity itementity = p.m_36176_(backpack, false);
            if (itementity != null) {
                itementity.m_32061_();
                itementity.m_32052_(p.m_20148_());
            }
        }
        itemEntity = p.m_36176_(backpack, false);
        if (itemEntity != null) {
            itemEntity.m_32065_();
        }
    }

    private static void dropBackpackToPosition(ItemStack backpack, ServerLevel level, Vec3 pos) {
        ItemEntity itemEntity = new ItemEntity((Level)level, pos.f_82479_, pos.f_82480_, pos.f_82481_, backpack, 0.0, 0.0, 0.0);
        level.m_7967_((Entity)itemEntity);
    }

    private record DynamicTemplate(ItemStack backpack, List<ItemStack> itemsForInventoryHandler, List<ItemStack> itemsForUpgradeHandler) {
    }
}

