/*
 * Decompiled with CFR 0.152.
 */
package toni.sodiumextras.foundation.fps;

import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import toni.sodiumextras.EmbyConfig;
import toni.sodiumextras.EmbyTools;
import toni.sodiumextras.SodiumExtras;
import toni.sodiumextras.foundation.fps.FPSDisplay;
import toni.sodiumextras.foundation.fps.FpsHistory;
import toni.sodiumextras.foundation.fps.accessors.IUsageGPU;

@Mod.EventBusSubscriber(modid="sodiumextras", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class DebugOverlayEvent {
    private static final FPSDisplay DISPLAY = new FPSDisplay();
    private static final Component MSG_FPS = Component.m_237115_((String)"sodium.extras.options.displayfps.fps");
    private static final Component MSG_MIN = Component.m_237115_((String)"sodium.extras.options.displayfps.min");
    private static final Component MSG_AVG = Component.m_237115_((String)"sodium.extras.options.displayfps.avg");
    private static final Component MSG_GPU = Component.m_237115_((String)"sodium.extras.options.displayfps.gpu");
    private static final Component MSG_MEM = Component.m_237115_((String)"sodium.extras.options.displayfps.mem");
    private static final AverageQueue AVERAGE = new AverageQueue();
    private static int fps = -1;
    private static int minFPS = -1;
    private static int lastAvgFps = -1;
    private static int avgFPS = -1;
    private static int gpuPercent = -1;
    private static int memUsage = -1;

    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiEvent.Pre event) {
        Minecraft minecraft = Minecraft.m_91087_();
        int currentFps = minecraft.m_260875_();
        SodiumExtras.fpsHistory.add(currentFps);
        DebugOverlayEvent.renderFPSChar(minecraft, event.getGuiGraphics());
    }

    public static void renderFPSChar(Minecraft mc, GuiGraphics graphics) {
        if (mc.f_91066_.f_92063_ || mc.f_91066_.f_92065_) {
            return;
        }
        Font font = mc.f_91062_;
        Integer scale = (Integer)mc.f_91066_.m_231928_().m_231551_();
        EmbyConfig.FPSDisplayMode mode = (EmbyConfig.FPSDisplayMode)((Object)EmbyConfig.fpsDisplayMode.get());
        EmbyConfig.FPSDisplaySystemMode systemMode = (EmbyConfig.FPSDisplaySystemMode)((Object)EmbyConfig.fpsDisplaySystemMode.get());
        if (mode.off() && systemMode.off()) {
            return;
        }
        DISPLAY.release();
        switch (mode) {
            case SIMPLE: {
                DISPLAY.append(DebugOverlayEvent.calculateFPS$getColor(mc)).add(DebugOverlayEvent.fix(fps)).add(" ").add(MSG_FPS.getString()).add(ChatFormatting.RESET);
                break;
            }
            case ADVANCED: {
                DISPLAY.append(DebugOverlayEvent.calculateFPS$getColor(mc)).add(DebugOverlayEvent.fix(fps)).add(ChatFormatting.RESET);
                DISPLAY.append(DebugOverlayEvent.calculateMinFPS$getColor(mc)).add(MSG_MIN).add(" ").add(DebugOverlayEvent.fix(minFPS)).add(ChatFormatting.RESET);
                DISPLAY.append(DebugOverlayEvent.calculateAvgFPS$getColor(mc)).add(MSG_AVG).add(" ").add(DebugOverlayEvent.fix(avgFPS)).add(ChatFormatting.RESET);
            }
        }
        if (!DISPLAY.isEmpty()) {
            DISPLAY.split();
        }
        switch (systemMode) {
            case GPU: {
                DISPLAY.append(DebugOverlayEvent.calculateGPUPercent$getColor(mc)).add(MSG_GPU).add(" ").add(DebugOverlayEvent.fix(gpuPercent)).add("%").add(ChatFormatting.RESET);
                break;
            }
            case RAM: {
                DISPLAY.append(DebugOverlayEvent.calculateMemPercent$getColor()).add(MSG_MEM).add(" ").add(DebugOverlayEvent.fix(memUsage)).add("%").add(ChatFormatting.RESET);
                break;
            }
            case ON: {
                DISPLAY.append(DebugOverlayEvent.calculateGPUPercent$getColor(mc)).add(MSG_GPU).add(" ").add(DebugOverlayEvent.fix(gpuPercent)).add("%").add(ChatFormatting.RESET);
                DISPLAY.append(DebugOverlayEvent.calculateMemPercent$getColor()).add(MSG_MEM).add(" ").add(DebugOverlayEvent.fix(memUsage)).add("%").add(ChatFormatting.RESET);
            }
        }
        if (DISPLAY.isEmpty()) {
            DISPLAY.add("FATAL ERROR");
        }
        float margin = scale > 0 ? (float)EmbyConfig.fpsDisplayMarginCache / (float)scale.intValue() : (float)EmbyConfig.fpsDisplayMarginCache;
        String displayString = DISPLAY.toString();
        float maxPosX = graphics.m_280182_() - font.m_92895_(displayString);
        float posX = switch ((EmbyConfig.FPSDisplayGravity)((Object)EmbyConfig.fpsDisplayGravity.get())) {
            default -> throw new IncompatibleClassChangeError();
            case EmbyConfig.FPSDisplayGravity.LEFT -> margin;
            case EmbyConfig.FPSDisplayGravity.CENTER -> maxPosX / 2.0f;
            case EmbyConfig.FPSDisplayGravity.RIGHT -> maxPosX - margin;
        };
        float posY = margin;
        graphics.m_280168_().m_85836_();
        if (EmbyConfig.fpsDisplayShadowCache) {
            int n = (int)posX - 2;
            int n2 = (int)posY - 2;
            int n3 = (int)posX + font.m_92895_(displayString) + 2;
            Objects.requireNonNull(font);
            graphics.m_280509_(n, n2, n3, (int)(posY + 9.0f) + 1, -1873784752);
            graphics.m_280262_();
        }
        graphics.m_280056_(font, displayString, (int)posX, (int)posY, -1, true);
        DISPLAY.release();
        graphics.m_280168_().m_85849_();
    }

    private static ChatFormatting calculateFPS$getColor(Minecraft mc) {
        fps = mc.m_260875_();
        return EmbyTools.colorByLow(fps);
    }

    private static ChatFormatting calculateMinFPS$getColor(Minecraft mc) {
        int min;
        FpsHistory history = SodiumExtras.fpsHistory;
        minFPS = min = history.getMinimum();
        return EmbyTools.colorByLow(minFPS);
    }

    private static ChatFormatting calculateAvgFPS$getColor(Minecraft mc) {
        if (mc.m_260875_() != lastAvgFps) {
            lastAvgFps = mc.m_260875_();
            AVERAGE.push(lastAvgFps);
            avgFPS = AVERAGE.calculate();
        }
        return EmbyTools.colorByLow(avgFPS);
    }

    private static ChatFormatting calculateGPUPercent$getColor(Minecraft mc) {
        int value = (int)((IUsageGPU)mc).embPlus$getSyncGpu();
        gpuPercent = value > 0 ? Math.min(value, 100) : -1;
        return EmbyTools.colorByPercent(gpuPercent);
    }

    private static ChatFormatting calculateMemPercent$getColor() {
        memUsage = (int)(EmbyTools.ramUsed() * 100L / Runtime.getRuntime().maxMemory());
        return EmbyTools.colorByPercent(memUsage);
    }

    private static String fix(int value) {
        return value == -1 ? "--" : "" + value;
    }

    public static class AverageQueue {
        private final int[] QUEUE = new int[14];
        private int used = 0;

        void push(int value) {
            if (this.used == this.QUEUE.length) {
                this.used = 0;
            }
            this.QUEUE[this.used] = value;
            ++this.used;
        }

        int calculate() {
            int times = 0;
            for (int i = 0; i < this.used; ++i) {
                times += this.QUEUE[i];
            }
            return times / this.used;
        }
    }
}

