/*
 * Decompiled with CFR 0.152.
 */
package com.simplyquarries;

import com.denfop.datagen.blocktags.BlockTagsProvider;
import com.denfop.dataregistry.DataBlockEntity;
import com.simplyquarries.BlockQuarry;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod(value="simplyquarries")
public class SimplyQuarries {
    public static DataBlockEntity<BlockQuarry> quarry;
    public static DeferredRegister<Item> ITEMS;
    public static DeferredRegister<Block> BLOCKS;
    public static DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES;
    private static SimplyQuarries instance;
    private final FMLJavaModLoadingContext context = FMLJavaModLoadingContext.get();

    public SimplyQuarries() {
        instance = this;
        MinecraftForge.EVENT_BUS.register((Object)this);
        BLOCKS.register(this.context.getModEventBus());
        BLOCK_ENTITIES.register(this.context.getModEventBus());
        ITEMS.register(this.context.getModEventBus());
        this.context.getModEventBus().addListener(this::gatherData);
        quarry = new DataBlockEntity(BlockQuarry.class, "simplyquarries", BLOCKS, BLOCK_ENTITIES, ITEMS);
    }

    @SubscribeEvent
    public void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput packOutput = gen.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        BlockTagsProvider blockTags = new BlockTagsProvider(packOutput, lookupProvider, "simplyquarries", existingFileHelper);
        gen.addProvider(event.includeServer(), (DataProvider)blockTags);
    }

    static {
        ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"simplyquarries");
        BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"simplyquarries");
        BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"simplyquarries");
    }
}

