/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.inventory;

import li.cil.scannable.common.inventory.ContainerSlice;
import li.cil.scannable.common.item.Items;
import li.cil.scannable.common.item.ScannerItem;
import li.cil.scannable.common.item.ScannerModuleItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public final class ScannerContainer
extends SimpleContainer {
    private static final int ACTIVE_MODULE_COUNT = 3;
    private static final int INACTIVE_MODULE_COUNT = 6;
    private static final int TOTAL_MODULE_COUNT = 9;
    private static final String TAG_ITEMS = "items";
    private static final String TAG_SLOT = "slot";
    private static final String TAG_ITEM = "item";
    private final ItemStack container;

    public ScannerContainer(ItemStack container) {
        super(9);
        this.container = container;
        CompoundTag tag = container.m_41783_();
        if (tag != null && tag.m_128425_(TAG_ITEMS, 9)) {
            this.m_7797_(tag.m_128437_(TAG_ITEMS, 10));
        }
    }

    public static ScannerContainer of(ItemStack container) {
        if (container.m_41720_() instanceof ScannerItem) {
            return new ScannerContainer(container);
        }
        return new ScannerContainer(new ItemStack((ItemLike)Items.SCANNER.get()));
    }

    public ContainerSlice getActiveModules() {
        return new ContainerSlice((Container)this, 0, 3);
    }

    public ContainerSlice getInactiveModules() {
        return new ContainerSlice((Container)this, 3, 6);
    }

    public void m_6836_(int i, ItemStack itemStack) {
        if (this.m_7013_(i, itemStack)) {
            super.m_6836_(i, itemStack);
        }
    }

    public boolean m_7013_(int i, ItemStack stack) {
        return this.isModule(stack) && super.m_7013_(i, stack);
    }

    public void m_6596_() {
        super.m_6596_();
        this.container.m_41700_(TAG_ITEMS, (Tag)this.m_7927_());
    }

    public ItemStack m_19173_(ItemStack stack) {
        if (this.m_19183_(stack)) {
            return super.m_19173_(stack);
        }
        return stack;
    }

    public boolean m_19183_(ItemStack stack) {
        return this.isModule(stack) && super.m_19183_(stack);
    }

    public void m_7797_(ListTag tag) {
        int i;
        for (i = 0; i < this.m_6643_(); ++i) {
            this.m_6836_(i, ItemStack.f_41583_);
        }
        for (i = 0; i < tag.size(); ++i) {
            CompoundTag slotTag = tag.m_128728_(i);
            int slot = slotTag.m_128445_(TAG_SLOT) & 0xFF;
            if (slot >= this.m_6643_()) continue;
            this.m_6836_(slot, ItemStack.m_41712_((CompoundTag)slotTag.m_128469_(TAG_ITEM)));
        }
    }

    public ListTag m_7927_() {
        ListTag tag = new ListTag();
        for (int i = 0; i < this.m_6643_(); ++i) {
            ItemStack stack = this.m_8020_(i);
            if (stack.m_41619_()) continue;
            CompoundTag slotTag = new CompoundTag();
            slotTag.m_128344_(TAG_SLOT, (byte)i);
            CompoundTag itemTag = new CompoundTag();
            stack.m_41739_(itemTag);
            slotTag.m_128365_(TAG_ITEM, (Tag)itemTag);
            tag.add((Object)slotTag);
        }
        return tag;
    }

    private boolean isModule(ItemStack stack) {
        if (stack.m_41720_() instanceof ScannerModuleItem) {
            return true;
        }
        return ScannerModuleItem.getModule(stack).isPresent();
    }
}

