/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.client;

import dev.architectury.injectables.annotations.ExpectPlatform;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import li.cil.scannable.client.forge.ClientConfigImpl;
import li.cil.scannable.util.config.Comment;
import li.cil.scannable.util.config.ConfigType;
import li.cil.scannable.util.config.CustomSerializer;
import li.cil.scannable.util.config.KeyValueTypes;
import li.cil.scannable.util.config.Type;
import li.cil.scannable.util.config.WorldRestart;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.material.MapColor;

@Type(value=ConfigType.CLIENT)
public final class ClientConfig {
    @WorldRestart
    @Comment(value={"The colors for blocks used when rendering their result bounding box\nby block name. Each entry must be a key-value pair separated by a `=`,\nwith the key being the tag name and the value being the hexadecimal\nRGB value of the color."})
    @KeyValueTypes(keyType=ResourceLocation.class, valueType=int.class, valueSerializer=@CustomSerializer(serializer="toHexString", deserializer="fromHexString"))
    public static Object2IntMap<ResourceLocation> blockColors = new Object2IntOpenHashMap();
    @WorldRestart
    @Comment(value={"The colors for blocks used when rendering their result bounding box\nby block tag. See `blockColors` for format entries have to be in."})
    @KeyValueTypes(keyType=ResourceLocation.class, valueType=int.class, valueSerializer=@CustomSerializer(serializer="toHexString", deserializer="fromHexString"))
    public static Object2IntMap<ResourceLocation> blockTagColors = ClientConfig.getDefaultBlockTagColors();
    @WorldRestart
    @Comment(value={"The colors for fluids used when rendering their result bounding box\nby fluid name. See `blockColors` for format entries have to be in."})
    @KeyValueTypes(keyType=ResourceLocation.class, valueType=int.class, valueSerializer=@CustomSerializer(serializer="toHexString", deserializer="fromHexString"))
    public static Object2IntMap<ResourceLocation> fluidColors = new Object2IntOpenHashMap();
    @WorldRestart
    @Comment(value={"The colors for fluids used when rendering their result bounding box\nby fluid tag. See `blockColors` for format entries have to be in."})
    @KeyValueTypes(keyType=ResourceLocation.class, valueType=int.class, valueSerializer=@CustomSerializer(serializer="toHexString", deserializer="fromHexString"))
    public static Object2IntMap<ResourceLocation> fluidTagColors = (Object2IntMap)Util.m_137469_((Object)new Object2IntOpenHashMap(), c -> {
        c.put((Object)FluidTags.f_13131_.f_203868_(), MapColor.f_283864_.f_283871_);
        c.put((Object)FluidTags.f_13132_.f_203868_(), MapColor.f_283895_.f_283871_);
    });

    public static String toHexString(Object value) {
        return "0x" + Integer.toHexString((Integer)value);
    }

    public static Object fromHexString(String value) {
        return Integer.decode(value);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static Object2IntMap<ResourceLocation> getDefaultBlockTagColors() {
        return ClientConfigImpl.getDefaultBlockTagColors();
    }
}

