/*
 * Decompiled with CFR 0.152.
 */
package com.powerutils;

import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.energy.networking.EnergyNetGlobal;
import com.denfop.api.energy.networking.NodeStats;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.componets.AbstractComponent;
import com.denfop.componets.Energy;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.inventory.InventoryUpgrade;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import com.powerutils.BlockPowerConverter;
import com.powerutils.ContainerMenuFEConverter;
import com.powerutils.PowerUtils;
import com.powerutils.ScreenFEConverter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

public class BlockEntityFEConverter
extends BlockEntityInventory
implements IUpdatableTileEvent,
IEnergyStorage,
IUpgradableBlock {
    public final Energy energy;
    public final InventoryUpgrade upgradeSlot;
    public final int defaultEnergyRFStorage;
    public final int defaultEnergyStorage;
    public double capacity;
    public double maxStorage2 = 400000.0;
    public double energy2 = 0.0;
    public boolean rf = true;
    public double differenceenergy = 0.0;
    public double perenergy = 0.0;
    public double differenceenergy1 = 0.0;
    public int tier = 5;
    public List<Player> list = new ArrayList<Player>();
    private long tick;

    public BlockEntityFEConverter(BlockPos pos, BlockState state) {
        super((MultiBlockEntity)BlockPowerConverter.power_utilities_fe, pos, state);
        this.energy = (Energy)this.addComponent((AbstractComponent)new Energy((BlockEntityInventory)this, 40000.0, ModUtils.allFacings, ModUtils.allFacings, 5, 5, false));
        this.energy.setDirections(ModUtils.allFacings, ModUtils.allFacings);
        this.upgradeSlot = new InventoryUpgrade((BlockEntityInventory)this, 4);
        this.defaultEnergyStorage = 40000;
        this.defaultEnergyRFStorage = 400000;
        this.capacity = this.energy.buffer.capacity;
    }

    public MultiBlockEntity getTeBlock() {
        return BlockPowerConverter.power_utilities_fe;
    }

    public BlockTileEntity getBlock() {
        return PowerUtils.itemPowerConverter.getBlock(this.getTeBlock());
    }

    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (this.hasComponent(Energy.class)) {
            Energy energy = (Energy)this.getComp(Energy.class);
            if (!energy.getSourceDirs().isEmpty()) {
                tooltip.add(Localization.translate((String)"iu.item.tooltip.PowerTier", (Object[])new Object[]{energy.getSourceTier()}));
            } else if (!energy.getSinkDirs().isEmpty()) {
                tooltip.add(Localization.translate((String)"iu.item.tooltip.PowerTier", (Object[])new Object[]{energy.getSinkTier()}));
            }
        }
    }

    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.energy2 = (Double)DecoderHandler.decode((CustomPacketBuffer)customPacketBuffer);
            this.capacity = (Double)DecoderHandler.decode((CustomPacketBuffer)customPacketBuffer);
            this.maxStorage2 = (Double)DecoderHandler.decode((CustomPacketBuffer)customPacketBuffer);
            this.perenergy = (Double)DecoderHandler.decode((CustomPacketBuffer)customPacketBuffer);
            this.rf = (Boolean)DecoderHandler.decode((CustomPacketBuffer)customPacketBuffer);
            this.tier = (Integer)DecoderHandler.decode((CustomPacketBuffer)customPacketBuffer);
            this.differenceenergy1 = (Double)DecoderHandler.decode((CustomPacketBuffer)customPacketBuffer);
            this.differenceenergy = (Double)DecoderHandler.decode((CustomPacketBuffer)customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode((CustomPacketBuffer)packet, (Object)this.energy2);
            EncoderHandler.encode((CustomPacketBuffer)packet, (Object)this.capacity);
            EncoderHandler.encode((CustomPacketBuffer)packet, (Object)this.maxStorage2);
            EncoderHandler.encode((CustomPacketBuffer)packet, (Object)this.perenergy);
            EncoderHandler.encode((CustomPacketBuffer)packet, (Object)this.rf);
            EncoderHandler.encode((CustomPacketBuffer)packet, (Object)this.tier);
            EncoderHandler.encode((CustomPacketBuffer)packet, (Object)this.differenceenergy1);
            EncoderHandler.encode((CustomPacketBuffer)packet, (Object)this.differenceenergy);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    public void onLoaded() {
        super.onLoaded();
        if (!this.f_58857_.f_46443_) {
            this.setOverclockRates();
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return cap == ForgeCapabilities.ENERGY ? LazyOptional.of(() -> this).cast() : super.getCapability(cap, side);
    }

    public void setOverclockRates() {
        int tier = this.upgradeSlot.getTier(5);
        this.energy.setSinkTier(tier);
        this.energy.setSourceTier(tier);
        this.energy.setCapacity(this.upgradeSlot.extraEnergyStorage + (double)this.defaultEnergyStorage);
        this.maxStorage2 = (double)this.defaultEnergyRFStorage + this.upgradeSlot.extraEnergyStorage * 4.0;
        this.tier = tier;
        this.capacity = this.energy.buffer.capacity;
    }

    public void m_6596_() {
        super.m_6596_();
        if (!this.f_58857_.f_46443_) {
            this.setOverclockRates();
        }
    }

    public int receiveEnergy(int paramInt, boolean paramBoolean) {
        if (this.rf) {
            return 0;
        }
        int i = (int)Math.min(this.maxStorage2 - this.energy2, (double)paramInt);
        if (!paramBoolean) {
            this.energy2 += (double)i;
            this.differenceenergy1 = i;
            if (this.tick != this.getWorld().m_46467_()) {
                this.tick = this.getWorld().m_46467_();
                this.perenergy = i;
            } else {
                this.perenergy += (double)i;
            }
        }
        return i;
    }

    public void updateEntityServer() {
        super.updateEntityServer();
        this.energy.setReceivingEnabled(!this.shouldEmitEnergy());
        this.energy.setSendingEnabled(this.shouldEmitEnergy());
        this.differenceenergy = 0.0;
        this.differenceenergy1 = 0.0;
        if (this.tick != this.getWorld().m_46467_()) {
            this.perenergy = 0.0;
        }
        if (this.rf) {
            if (this.energy.getEnergy() > 0.0 && this.energy2 < this.maxStorage2) {
                double add = Math.min(this.maxStorage2 - this.energy2, this.energy.getEnergy() * 4.0);
                add = Math.max(add, 0.0);
                this.energy2 += add;
                this.energy.useEnergy(add / 4.0);
            }
        } else if (this.energy2 > 0.0 && this.energy.getEnergy() < this.energy.getCapacity()) {
            double k = this.energy.addEnergy(this.energy2 / 4.0) * 4.0;
            this.energy2 -= k;
        }
        if (!this.list.isEmpty()) {
            NodeStats stats = EnergyNetGlobal.instance.getNodeStats(this.energy.getDelegate(), this.f_58857_);
            if (this.rf) {
                if (stats != null) {
                    this.differenceenergy1 = stats.getEnergyIn();
                }
            } else if (stats != null) {
                this.differenceenergy = stats.getEnergyOut();
            }
        }
        int transfer = (int)Math.min(this.energy2, EnergyNetGlobal.instance.getPowerFromTier(this.energy.getSourceTier()));
        this.energy2 -= (double)transfer;
        this.energy2 += (double)this.transmitEnergy(transfer);
        boolean needsInvUpdate = this.upgradeSlot.tickNoMark();
        if (needsInvUpdate) {
            this.setOverclockRates();
        }
        this.energy2 = Math.min(this.energy2, this.maxStorage2);
    }

    private int transmitEnergy(int energy) {
        Direction[] var2;
        for (Direction e : var2 = Direction.values()) {
            BlockEntity te;
            BlockPos neighbor = this.m_58899_().m_121955_(e.m_122436_());
            if (!this.f_58857_.m_46749_(neighbor) || (te = this.f_58857_.m_7702_(neighbor)) == null) continue;
            IEnergyStorage storage = null;
            if (te.getCapability(ForgeCapabilities.ENERGY, e.m_122424_()).orElse(null) != null) {
                storage = (IEnergyStorage)te.getCapability(ForgeCapabilities.ENERGY, e.m_122424_()).orElse(null);
            } else if (te.getCapability(ForgeCapabilities.ENERGY, null).orElse(null) != null) {
                storage = (IEnergyStorage)te.getCapability(ForgeCapabilities.ENERGY, null).orElse(null);
            }
            if (storage == null || (energy -= storage.receiveEnergy(energy, false)) > 0) continue;
            return 0;
        }
        return energy;
    }

    protected boolean shouldEmitEnergy() {
        return !this.rf;
    }

    public int extractEnergy(int paramInt, boolean paramBoolean) {
        if (!this.rf) {
            return 0;
        }
        int i = (int)Math.min(Math.min(this.energy2, EnergyNetGlobal.instance.getPowerFromTier(this.energy.getSourceTier())), (double)paramInt);
        if (!paramBoolean) {
            this.energy2 -= (double)i;
            this.differenceenergy += (double)i;
        }
        return i;
    }

    public int getEnergyStored() {
        return (int)this.energy2;
    }

    public int getMaxEnergyStored() {
        return (int)this.maxStorage2;
    }

    public boolean canExtract() {
        return this.rf;
    }

    public boolean canReceive() {
        return !this.rf;
    }

    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.energy.setDirections(ModUtils.allFacings, ModUtils.allFacings);
        this.tier = nbttagcompound.m_128451_("tier");
        this.energy2 = ModUtils.limit((double)nbttagcompound.m_128459_("energy2"), (double)0.0, (double)this.maxStorage2);
        this.rf = nbttagcompound.m_128471_("rf");
    }

    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        if (this.energy2 > 0.0) {
            nbttagcompound.m_128347_("energy2", this.energy2);
        }
        nbttagcompound.m_128405_("tier", this.tier);
        nbttagcompound.m_128379_("rf", this.rf);
        return nbttagcompound;
    }

    public int getCapacity() {
        return (int)this.energy.getCapacity();
    }

    public int getOutput() {
        return (int)EnergyNetGlobal.instance.getPowerFromTier(this.energy.getSourceTier());
    }

    public int addEnergy(int amount) {
        this.energy.addEnergy((double)amount);
        return amount;
    }

    public ContainerMenuFEConverter getGuiContainer(Player player) {
        this.list.add(player);
        return new ContainerMenuFEConverter(player, this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenFEConverter((ContainerMenuFEConverter)menu);
    }

    public void updateTileServer(Player player, double event) {
        this.rf = !this.rf;
    }

    public int gaugeICEnergyScaled(int i) {
        return (int)Math.min(this.energy.getEnergy() * (double)i / this.energy.getCapacity(), (double)i);
    }

    public int gaugeTEEnergyScaled(int i) {
        this.maxStorage2 = (double)this.defaultEnergyRFStorage + this.upgradeSlot.extraEnergyStorage * 4.0;
        return (int)Math.min(this.energy2 * (double)i / this.maxStorage2, (double)i);
    }

    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage);
    }
}

