/*
 * Decompiled with CFR 0.152.
 */
package com.miningworld;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.miningworld.CustomOreConfig;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="miningworld")
public class OreConfigLoader
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final Map<ResourceLocation, CustomOreConfig> ORES = new HashMap<ResourceLocation, CustomOreConfig>();
    public static Logger LOGGER = LogUtils.getLogger();

    public OreConfigLoader() {
        super(GSON, "miningworld");
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profiler) {
        ORES.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
            try {
                CustomOreConfig config = CustomOreConfig.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)entry.getValue()).resultOrPartial(err -> LOGGER.warn("[OreConfigLoader] Error parsing " + entry.getKey() + ": " + err)).orElse(null);
                if (config == null) continue;
                ORES.put(entry.getKey(), config);
            }
            catch (Exception e) {
                LOGGER.error("[OreConfigLoader] Failed to load " + entry.getKey() + ": " + e);
            }
        }
        LOGGER.warn("[OreConfigLoader] Loaded ores: " + ORES.size());
    }

    @SubscribeEvent
    public static void onAddReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new OreConfigLoader());
    }
}

