/*
 * Decompiled with CFR 0.152.
 */
package com.miningworld;

import com.miningworld.ConfiguredFeaturesGen;
import com.miningworld.GlobalOreFeature;
import com.miningworld.ModPlacedFeatures;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod(value="miningworld")
public class MiningWorld {
    private static MiningWorld instance;
    private final FMLJavaModLoadingContext context = FMLJavaModLoadingContext.get();
    public static DeferredRegister<Feature<?>> FEATURES;
    public static RegistryObject<GlobalOreFeature> global_ores;
    private static final RegistrySetBuilder BUILDER;

    public MiningWorld() {
        FEATURES.register(this.context.getModEventBus());
        global_ores = FEATURES.register("global_ores", GlobalOreFeature::new);
        this.context.getModEventBus().addListener(this::gatherData);
    }

    @SubscribeEvent
    public void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput packOutput = gen.getPackOutput();
        gen.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(packOutput, event.getLookupProvider(), BUILDER, Set.of("miningworld")));
    }

    static {
        FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"miningworld");
        BUILDER = new RegistrySetBuilder().m_254916_(Registries.f_256911_, ConfiguredFeaturesGen::bootstrap).m_254916_(Registries.f_256988_, ModPlacedFeatures::bootstrap);
    }

    @Mod.EventBusSubscriber(modid="miningworld")
    public static class Commands {
        @SubscribeEvent
        public static void registerCommands(RegisterCommandsEvent event) {
            CommandDispatcher dispatcher = event.getDispatcher();
            dispatcher.register((LiteralArgumentBuilder)net.minecraft.commands.Commands.m_82127_((String)"digdim").executes(context -> {
                ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
                ResourceKey dimKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("miningworld", "digging_dimension"));
                ServerLevel target = player.m_20194_().m_129880_(dimKey);
                if (target == null) {
                    ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Dimension not found"));
                    return 0;
                }
                if (player.m_9236_().m_46472_() != dimKey) {
                    player.m_8999_(target, 0.5, 77.0, 0.5, player.m_146908_(), player.m_146909_());
                } else {
                    target = player.m_20194_().m_129880_(Level.f_46428_);
                    int height = target.m_6924_(Heightmap.Types.WORLD_SURFACE, 0, 0);
                    player.m_8999_(target, 0.5, (double)height, 0.5, player.m_146908_(), player.m_146909_());
                }
                return 1;
            }));
        }
    }
}

