/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.definition;

import appeng.core.localization.LocalizationEnum;

public enum MEGATranslations implements LocalizationEnum
{
    AcceleratorThreads("Provides 4 co-processing threads per block.", Type.TOOLTIP),
    ALot("A lot.", Type.TOOLTIP),
    Compression("Compression: %s", Type.TOOLTIP),
    Contains("Contains: %s", Type.TOOLTIP),
    Disabled("Disabled", Type.TOOLTIP),
    Empty("Empty", Type.TOOLTIP),
    Enabled("Enabled", Type.TOOLTIP),
    FilterChemicalUnsupported("Filter chemical unsupported!", Type.TOOLTIP),
    MismatchedFilter("Mismatched filter!", Type.TOOLTIP),
    ModName("MEGA Cells", Type.GUI),
    PartitionedFor("Partitioned for: %s", Type.TOOLTIP),
    ProcessingOnly("Supports processing patterns only.", Type.TOOLTIP),
    Quantity("Quantity: %s", Type.TOOLTIP),
    NotPartitioned("Not Partitioned", Type.TOOLTIP),
    CompressionChainLimit("Bulk Compression chain limit", Type.CONFIG_OPTION),
    CompressionChainLimitTooltip("The maximum number of variants that a compression-enabled Bulk Cell may report as being stored.", Type.CONFIG_TOOLTIP, CompressionChainLimit),
    AllowSpentWaste("(AppMek) Allow Spent Nuclear Waste", Type.CONFIG_OPTION),
    AllowSpentWasteTooltip("Whether the MEGA Radioactive Cell should be able to store Spent Nuclear Waste.", Type.CONFIG_TOOLTIP, AllowSpentWaste);

    private final String englishText;
    private final Type type;
    private final MEGATranslations associated;

    private MEGATranslations(String englishText, Type type) {
        this(englishText, type, null);
    }

    private MEGATranslations(String englishText, Type type, MEGATranslations associated) {
        this.englishText = englishText;
        this.type = type;
        this.associated = associated;
    }

    public String getEnglishText() {
        return this.englishText;
    }

    public String getTranslationKey() {
        return switch (this.type) {
            case Type.CONFIG_OPTION -> this.type.root.formatted("megacells") + "." + this.name();
            case Type.CONFIG_TOOLTIP -> this.type.root.formatted("megacells") + "." + this.associated.name() + ".@Tooltip";
            default -> String.format("%s.%s.%s", this.type.root, "megacells", this.name());
        };
    }

    private static enum Type {
        GUI("gui"),
        TOOLTIP("gui.tooltips"),
        CONFIG_OPTION("text.autoconfig.%s.option"),
        CONFIG_TOOLTIP("text.autoconfig.%s.option");

        private final String root;

        private Type(String root) {
            this.root = root;
        }
    }
}

