/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.siteexport;

import com.mojang.blaze3d.platform.NativeImage;
import org.bytedeco.ffmpeg.avcodec.AVCodec;
import org.bytedeco.ffmpeg.avcodec.AVCodecContext;
import org.bytedeco.ffmpeg.avcodec.AVCodecParameters;
import org.bytedeco.ffmpeg.avcodec.AVPacket;
import org.bytedeco.ffmpeg.avformat.AVFormatContext;
import org.bytedeco.ffmpeg.avformat.AVIOContext;
import org.bytedeco.ffmpeg.avformat.AVStream;
import org.bytedeco.ffmpeg.avutil.AVDictionary;
import org.bytedeco.ffmpeg.avutil.AVFrame;
import org.bytedeco.ffmpeg.avutil.AVRational;
import org.bytedeco.ffmpeg.global.avcodec;
import org.bytedeco.ffmpeg.global.avformat;
import org.bytedeco.ffmpeg.global.avutil;
import org.bytedeco.ffmpeg.global.swscale;
import org.bytedeco.ffmpeg.swscale.SwsContext;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerPointer;

public class WebPExporter
implements AutoCloseable {
    private final AVCodec codec;
    private final AVFormatContext formatContext;
    private final AVStream stream;
    private final AVCodecContext codecContext;
    private final AVPacket packet;
    private final AVFrame frame;
    private final AVFrame rgbFrame;
    private final SwsContext swsCtx;

    public WebPExporter(int width, int height, Format format) {
        try {
            this.formatContext = new AVFormatContext();
            WebPExporter.check(avformat.avformat_alloc_output_context2((AVFormatContext)this.formatContext, null, (String)"webp", null));
            this.stream = avformat.avformat_new_stream((AVFormatContext)this.formatContext, null);
            if (this.stream.isNull()) {
                throw new RuntimeException("Couldn't create new stream");
            }
            this.codec = avcodec.avcodec_find_encoder((int)171);
            if (this.codec.isNull()) {
                throw new RuntimeException("Couldn't find webp codec");
            }
            this.codecContext = avcodec.avcodec_alloc_context3((AVCodec)this.codec);
            if (this.codecContext.isNull()) {
                throw new RuntimeException("Couldn't alloc context");
            }
            this.packet = avcodec.av_packet_alloc();
            if (this.packet.isNull()) {
                throw new RuntimeException("Packet cannot be allocated");
            }
            this.codecContext.width(width);
            this.codecContext.height(height);
            int targetFormat = switch (format) {
                default -> throw new IncompatibleClassChangeError();
                case Format.LOSSLESS_ALPHA, Format.LOSSLESS -> avutil.AV_PIX_FMT_RGB32;
                case Format.NORMAL -> 0;
                case Format.NORMAL_ALPHA -> 33;
            };
            this.codecContext.pix_fmt(targetFormat);
            this.codecContext.time_base(new AVRational());
            this.codecContext.time_base().num(1);
            this.codecContext.time_base().den(20);
            this.codecContext.framerate(new AVRational());
            this.codecContext.framerate().num(20);
            this.codecContext.framerate().den(1);
            if ((this.formatContext.oformat().flags() & 0x40) != 0) {
                this.codecContext.flags(this.codecContext.flags() | 0x400000);
            }
            AVDictionary codecOptions = new AVDictionary();
            if (format.lossless) {
                avutil.av_dict_set_int((AVDictionary)codecOptions, (String)"lossless", (long)1L, (int)0);
            } else {
                avutil.av_dict_set((AVDictionary)codecOptions, (String)"preset", (String)"icon", (int)0);
            }
            WebPExporter.check(avcodec.avcodec_open2((AVCodecContext)this.codecContext, (AVCodec)this.codec, (AVDictionary)codecOptions));
            AVCodecParameters codecpar = this.stream.codecpar();
            WebPExporter.check(avcodec.avcodec_parameters_from_context((AVCodecParameters)codecpar, (AVCodecContext)this.codecContext));
            this.stream.codecpar(codecpar);
            this.stream.time_base(new AVRational());
            this.stream.time_base().num(1);
            this.stream.time_base().den(20);
            this.frame = avutil.av_frame_alloc();
            if (this.frame.isNull()) {
                throw new RuntimeException("Failed to allocate frame");
            }
            this.frame.format(this.codecContext.pix_fmt());
            this.frame.width(this.codecContext.width());
            this.frame.height(this.codecContext.height());
            WebPExporter.check(avutil.av_frame_get_buffer((AVFrame)this.frame, (int)0));
            this.rgbFrame = avutil.av_frame_alloc();
            if (this.rgbFrame.isNull()) {
                throw new RuntimeException("Failed to allocate frame");
            }
            this.rgbFrame.format(format.alpha ? 26 : 119);
            this.rgbFrame.width(this.codecContext.width());
            this.rgbFrame.height(this.codecContext.height());
            WebPExporter.check(avutil.av_frame_get_buffer((AVFrame)this.rgbFrame, (int)0));
            AVIOContext pb = new AVIOContext(null);
            WebPExporter.check(avformat.avio_open_dyn_buf((AVIOContext)pb));
            this.formatContext.pb(pb);
            this.swsCtx = swscale.sws_getContext((int)this.rgbFrame.width(), (int)this.rgbFrame.height(), (int)this.rgbFrame.format(), (int)this.frame.width(), (int)this.frame.height(), (int)this.frame.format(), (int)1, null, null, (DoublePointer)null);
            if (this.swsCtx.isNull()) {
                throw new RuntimeException("Failed to allocate sws context");
            }
            AVDictionary formatOptions = new AVDictionary();
            avutil.av_dict_set_int((AVDictionary)formatOptions, (String)"loop", (long)0L, (int)0);
            WebPExporter.check(avformat.avformat_write_header((AVFormatContext)this.formatContext, (AVDictionary)formatOptions));
        }
        catch (RuntimeException e) {
            this.close();
            throw e;
        }
    }

    public void writeFrame(int index, NativeImage nativeImage) {
        WebPExporter.check(avutil.av_frame_make_writable((AVFrame)this.frame));
        int[] pixels = nativeImage.m_266370_();
        BytePointer data = this.rgbFrame.data(0);
        for (int i = 0; i < pixels.length; ++i) {
            data.putInt((long)i * 4L, pixels[i]);
        }
        swscale.sws_scale((SwsContext)this.swsCtx, (PointerPointer)this.rgbFrame.data(), (IntPointer)this.rgbFrame.linesize(), (int)0, (int)this.codecContext.height(), (PointerPointer)this.frame.data(), (IntPointer)this.frame.linesize());
        this.frame.pts((long)index);
        WebPExporter.encode(this.formatContext, this.codecContext, this.packet, this.stream, this.frame);
    }

    public byte[] finish() {
        WebPExporter.encode(this.formatContext, this.codecContext, this.packet, this.stream, null);
        WebPExporter.check(avformat.av_write_trailer((AVFormatContext)this.formatContext));
        BytePointer pb = new BytePointer();
        int pbSize = avformat.avio_get_dyn_buf((AVIOContext)this.formatContext.pb(), (BytePointer)pb);
        byte[] data = new byte[pbSize];
        pb.get(data);
        return data;
    }

    private static void encode(AVFormatContext formatContext, AVCodecContext codecContext, AVPacket packet, AVStream stream, AVFrame frame) {
        WebPExporter.check(avcodec.avcodec_send_frame((AVCodecContext)codecContext, (AVFrame)frame));
        int err;
        while ((err = avcodec.avcodec_receive_packet((AVCodecContext)codecContext, (AVPacket)packet)) != avutil.AVERROR_EAGAIN() && err != avutil.AVERROR_EOF) {
            WebPExporter.check(err);
            avcodec.av_packet_rescale_ts((AVPacket)packet, (AVRational)codecContext.time_base(), (AVRational)stream.time_base());
            packet.stream_index(stream.index());
            WebPExporter.check(avformat.av_interleaved_write_frame((AVFormatContext)formatContext, (AVPacket)packet));
        }
        return;
    }

    private static void check(int err) {
        if (err < 0) {
            throw new RuntimeException(WebPExporter.getErrorString(err) + " (" + err + ")");
        }
    }

    private static String getErrorString(int err) {
        BytePointer e = new BytePointer(512L);
        if (avutil.av_strerror((int)err, (BytePointer)e, (long)512L) < 0) {
            return "Unknown Error";
        }
        return e.getString().substring(0, (int)BytePointer.strlen((BytePointer)e));
    }

    @Override
    public void close() {
        if (this.codecContext != null) {
            avcodec.avcodec_free_context((AVCodecContext)this.codecContext);
        }
        if (this.frame != null) {
            avutil.av_frame_free((AVFrame)this.frame);
        }
        if (this.rgbFrame != null) {
            avutil.av_frame_free((AVFrame)this.rgbFrame);
        }
        if (this.codec != null) {
            this.codec.close();
        }
        if (this.formatContext != null && !this.formatContext.pb().isNull()) {
            BytePointer pb = new BytePointer();
            avformat.avio_close_dyn_buf((AVIOContext)this.formatContext.pb(), (BytePointer)pb);
            avutil.av_free((Pointer)pb);
        }
        if (this.formatContext != null) {
            avformat.avformat_free_context((AVFormatContext)this.formatContext);
        }
    }

    public static enum Format {
        LOSSLESS_ALPHA(true, true),
        LOSSLESS(true, false),
        NORMAL_ALPHA(false, true),
        NORMAL(false, false);

        final boolean lossless;
        final boolean alpha;

        private Format(boolean lossless, boolean alpha) {
            this.lossless = lossless;
            this.alpha = alpha;
        }
    }
}

