/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.util;

import guideme.internal.shaded.lucene.util.BitUtil;
import java.math.BigInteger;
import java.util.Arrays;

public final class NumericUtils {
    private NumericUtils() {
    }

    public static long doubleToSortableLong(double value) {
        return NumericUtils.sortableDoubleBits(Double.doubleToLongBits(value));
    }

    public static double sortableLongToDouble(long encoded) {
        return Double.longBitsToDouble(NumericUtils.sortableDoubleBits(encoded));
    }

    public static int floatToSortableInt(float value) {
        return NumericUtils.sortableFloatBits(Float.floatToIntBits(value));
    }

    public static float sortableIntToFloat(int encoded) {
        return Float.intBitsToFloat(NumericUtils.sortableFloatBits(encoded));
    }

    public static long sortableDoubleBits(long bits) {
        return bits ^ bits >> 63 & Long.MAX_VALUE;
    }

    public static int sortableFloatBits(int bits) {
        return bits ^ bits >> 31 & Integer.MAX_VALUE;
    }

    public static void subtract(int bytesPerDim, int dim, byte[] a, byte[] b, byte[] result) {
        int start = dim * bytesPerDim;
        int end = start + bytesPerDim;
        int borrow = 0;
        for (int i = end - 1; i >= start; --i) {
            int diff = (a[i] & 0xFF) - (b[i] & 0xFF) - borrow;
            if (diff < 0) {
                diff += 256;
                borrow = 1;
            } else {
                borrow = 0;
            }
            result[i - start] = (byte)diff;
        }
        if (borrow != 0) {
            throw new IllegalArgumentException("a < b");
        }
    }

    public static void add(int bytesPerDim, int dim, byte[] a, byte[] b, byte[] result) {
        int start = dim * bytesPerDim;
        int end = start + bytesPerDim;
        int carry = 0;
        for (int i = end - 1; i >= start; --i) {
            int digitSum = (a[i] & 0xFF) + (b[i] & 0xFF) + carry;
            if (digitSum > 255) {
                digitSum -= 256;
                carry = 1;
            } else {
                carry = 0;
            }
            result[i - start] = (byte)digitSum;
        }
        if (carry != 0) {
            throw new IllegalArgumentException("a + b overflows bytesPerDim=" + bytesPerDim);
        }
    }

    public static boolean nextUp(byte[] bytes) {
        boolean isMax = true;
        for (byte b : bytes) {
            if (b == -1) continue;
            isMax = false;
            break;
        }
        if (isMax) {
            return false;
        }
        int i = bytes.length - 1;
        while (i >= 0) {
            int n = i--;
            bytes[n] = (byte)(bytes[n] + 1);
            if (bytes[n] != 0) break;
        }
        return true;
    }

    public static boolean nextDown(byte[] bytes) {
        boolean isMin = true;
        for (byte b : bytes) {
            if (b == 0) continue;
            isMin = false;
            break;
        }
        if (isMin) {
            return false;
        }
        int i = bytes.length - 1;
        while (i >= 0) {
            int n = i--;
            byte by = bytes[n];
            bytes[n] = (byte)(by - 1);
            if (by != 0) break;
        }
        return true;
    }

    public static void intToSortableBytes(int value, byte[] result, int offset) {
        BitUtil.VH_BE_INT.set(result, offset, value ^= Integer.MIN_VALUE);
    }

    public static int sortableBytesToInt(byte[] encoded, int offset) {
        int x = BitUtil.VH_BE_INT.get(encoded, offset);
        return x ^ Integer.MIN_VALUE;
    }

    public static void longToSortableBytes(long value, byte[] result, int offset) {
        BitUtil.VH_BE_LONG.set(result, offset, value ^= Long.MIN_VALUE);
    }

    public static long sortableBytesToLong(byte[] encoded, int offset) {
        long v = BitUtil.VH_BE_LONG.get(encoded, offset);
        return v ^= Long.MIN_VALUE;
    }

    public static void bigIntToSortableBytes(BigInteger bigInt, int bigIntSize, byte[] result, int offset) {
        byte[] fullBigIntBytes;
        byte[] bigIntBytes = bigInt.toByteArray();
        if (bigIntBytes.length < bigIntSize) {
            fullBigIntBytes = new byte[bigIntSize];
            System.arraycopy(bigIntBytes, 0, fullBigIntBytes, bigIntSize - bigIntBytes.length, bigIntBytes.length);
            if ((bigIntBytes[0] & 0x80) != 0) {
                Arrays.fill(fullBigIntBytes, 0, bigIntSize - bigIntBytes.length, (byte)-1);
            }
        } else if (bigIntBytes.length == bigIntSize) {
            fullBigIntBytes = bigIntBytes;
        } else {
            throw new IllegalArgumentException("BigInteger: " + bigInt + " requires more than " + bigIntSize + " bytes storage");
        }
        fullBigIntBytes[0] = (byte)(fullBigIntBytes[0] ^ 0x80);
        System.arraycopy(fullBigIntBytes, 0, result, offset, bigIntSize);
        assert (NumericUtils.sortableBytesToBigInt(result, offset, bigIntSize).equals(bigInt)) : "bigInt=" + bigInt + " converted=" + NumericUtils.sortableBytesToBigInt(result, offset, bigIntSize);
    }

    public static BigInteger sortableBytesToBigInt(byte[] encoded, int offset, int length) {
        byte[] bigIntBytes = new byte[length];
        System.arraycopy(encoded, offset, bigIntBytes, 0, length);
        bigIntBytes[0] = (byte)(bigIntBytes[0] ^ 0x80);
        return new BigInteger(bigIntBytes);
    }
}

