/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.store;

import guideme.internal.shaded.lucene.store.AlreadyClosedException;
import guideme.internal.shaded.lucene.store.Directory;
import guideme.internal.shaded.lucene.store.Lock;
import guideme.internal.shaded.lucene.store.LockFactory;
import java.io.IOException;

public abstract class BaseDirectory
extends Directory {
    protected volatile boolean isOpen = true;
    protected final LockFactory lockFactory;

    protected BaseDirectory(LockFactory lockFactory) {
        if (lockFactory == null) {
            throw new NullPointerException("LockFactory must not be null, use an explicit instance!");
        }
        this.lockFactory = lockFactory;
    }

    @Override
    public final Lock obtainLock(String name) throws IOException {
        return this.lockFactory.obtainLock(this, name);
    }

    @Override
    protected final void ensureOpen() throws AlreadyClosedException {
        if (!this.isOpen) {
            throw new AlreadyClosedException("this Directory is closed");
        }
    }

    @Override
    public String toString() {
        return super.toString() + " lockFactory=" + this.lockFactory;
    }
}

