/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.search.FuzzyTermsEnum;
import guideme.internal.shaded.lucene.util.UnicodeUtil;
import guideme.internal.shaded.lucene.util.automaton.CompiledAutomaton;
import guideme.internal.shaded.lucene.util.automaton.LevenshteinAutomata;
import guideme.internal.shaded.lucene.util.automaton.TooComplexToDeterminizeException;

class FuzzyAutomatonBuilder {
    private final String term;
    private final int maxEdits;
    private final LevenshteinAutomata levBuilder;
    private final String prefix;
    private final int termLength;

    FuzzyAutomatonBuilder(String term, int maxEdits, int prefixLength, boolean transpositions) {
        if (maxEdits < 0 || maxEdits > 2) {
            throw new IllegalArgumentException("max edits must be 0..2, inclusive; got: " + maxEdits);
        }
        if (prefixLength < 0) {
            throw new IllegalArgumentException("prefixLength cannot be less than 0");
        }
        this.term = term;
        this.maxEdits = maxEdits;
        int[] codePoints = FuzzyAutomatonBuilder.stringToUTF32(term);
        this.termLength = codePoints.length;
        prefixLength = Math.min(prefixLength, codePoints.length);
        int[] suffix = new int[codePoints.length - prefixLength];
        System.arraycopy(codePoints, prefixLength, suffix, 0, suffix.length);
        this.levBuilder = new LevenshteinAutomata(suffix, 0x10FFFF, transpositions);
        this.prefix = UnicodeUtil.newString(codePoints, 0, prefixLength);
    }

    CompiledAutomaton[] buildAutomatonSet() {
        CompiledAutomaton[] compiled = new CompiledAutomaton[this.maxEdits + 1];
        for (int i = 0; i <= this.maxEdits; ++i) {
            try {
                compiled[i] = new CompiledAutomaton(this.levBuilder.toAutomaton(i, this.prefix), true, false);
                continue;
            }
            catch (TooComplexToDeterminizeException e) {
                throw new FuzzyTermsEnum.FuzzyTermsException(this.term, e);
            }
        }
        return compiled;
    }

    CompiledAutomaton buildMaxEditAutomaton() {
        try {
            return new CompiledAutomaton(this.levBuilder.toAutomaton(this.maxEdits, this.prefix), true, false);
        }
        catch (TooComplexToDeterminizeException e) {
            throw new FuzzyTermsEnum.FuzzyTermsException(this.term, e);
        }
    }

    int getTermLength() {
        return this.termLength;
    }

    private static int[] stringToUTF32(String text) {
        int cp;
        int[] termText = new int[text.codePointCount(0, text.length())];
        int j = 0;
        for (int i = 0; i < text.length(); i += Character.charCount(cp)) {
            termText[j++] = cp = text.codePointAt(i);
        }
        return termText;
    }
}

